package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DocumentReviews(
    action: zio.aws.ssm.model.DocumentReviewAction,
    comment: Option[Iterable[zio.aws.ssm.model.DocumentReviewCommentSource]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DocumentReviews = {
    import DocumentReviews.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DocumentReviews
      .builder()
      .action(action.unwrap)
      .optionallyWith(
        comment.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.comment)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DocumentReviews.ReadOnly =
    zio.aws.ssm.model.DocumentReviews.wrap(buildAwsValue())
}
object DocumentReviews {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DocumentReviews
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DocumentReviews =
      zio.aws.ssm.model.DocumentReviews(
        action,
        comment.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def action: zio.aws.ssm.model.DocumentReviewAction
    def comment
        : Option[List[zio.aws.ssm.model.DocumentReviewCommentSource.ReadOnly]]
    def getAction: ZIO[Any, Nothing, zio.aws.ssm.model.DocumentReviewAction] =
      ZIO.succeed(action)
    def getComment: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.DocumentReviewCommentSource.ReadOnly
    ]] = AwsError.unwrapOptionField("comment", comment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DocumentReviews
  ) extends zio.aws.ssm.model.DocumentReviews.ReadOnly {
    override val action: zio.aws.ssm.model.DocumentReviewAction =
      zio.aws.ssm.model.DocumentReviewAction.wrap(impl.action())
    override val comment
        : Option[List[zio.aws.ssm.model.DocumentReviewCommentSource.ReadOnly]] =
      scala
        .Option(impl.comment())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.DocumentReviewCommentSource.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DocumentReviews
  ): zio.aws.ssm.model.DocumentReviews.ReadOnly = new Wrapper(impl)
}
