package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait DocumentStatus {
  def unwrap: software.amazon.awssdk.services.ssm.model.DocumentStatus
}
object DocumentStatus {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.DocumentStatus
  ): zio.aws.ssm.model.DocumentStatus = value match {
    case software.amazon.awssdk.services.ssm.model.DocumentStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.DocumentStatus.CREATING =>
      val r = Creating
      r
    case software.amazon.awssdk.services.ssm.model.DocumentStatus.ACTIVE =>
      val r = Active
      r
    case software.amazon.awssdk.services.ssm.model.DocumentStatus.UPDATING =>
      val r = Updating
      r
    case software.amazon.awssdk.services.ssm.model.DocumentStatus.DELETING =>
      val r = Deleting
      r
    case software.amazon.awssdk.services.ssm.model.DocumentStatus.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.DocumentStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentStatus =
      software.amazon.awssdk.services.ssm.model.DocumentStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Creating extends zio.aws.ssm.model.DocumentStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentStatus =
      software.amazon.awssdk.services.ssm.model.DocumentStatus.CREATING
  }
  case object Active extends zio.aws.ssm.model.DocumentStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentStatus =
      software.amazon.awssdk.services.ssm.model.DocumentStatus.ACTIVE
  }
  case object Updating extends zio.aws.ssm.model.DocumentStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentStatus =
      software.amazon.awssdk.services.ssm.model.DocumentStatus.UPDATING
  }
  case object Deleting extends zio.aws.ssm.model.DocumentStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentStatus =
      software.amazon.awssdk.services.ssm.model.DocumentStatus.DELETING
  }
  case object Failed extends zio.aws.ssm.model.DocumentStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentStatus =
      software.amazon.awssdk.services.ssm.model.DocumentStatus.FAILED
  }
}
