package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EffectivePatch(
    patch: Option[zio.aws.ssm.model.Patch] = None,
    patchStatus: Option[zio.aws.ssm.model.PatchStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.EffectivePatch = {
    import EffectivePatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.EffectivePatch
      .builder()
      .optionallyWith(patch.map(value => value.buildAwsValue()))(_.patch)
      .optionallyWith(patchStatus.map(value => value.buildAwsValue()))(
        _.patchStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.EffectivePatch.ReadOnly =
    zio.aws.ssm.model.EffectivePatch.wrap(buildAwsValue())
}
object EffectivePatch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.EffectivePatch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.EffectivePatch =
      zio.aws.ssm.model.EffectivePatch(
        patch.map(value => value.asEditable),
        patchStatus.map(value => value.asEditable)
      )
    def patch: Option[zio.aws.ssm.model.Patch.ReadOnly]
    def patchStatus: Option[zio.aws.ssm.model.PatchStatus.ReadOnly]
    def getPatch: ZIO[Any, AwsError, zio.aws.ssm.model.Patch.ReadOnly] =
      AwsError.unwrapOptionField("patch", patch)
    def getPatchStatus
        : ZIO[Any, AwsError, zio.aws.ssm.model.PatchStatus.ReadOnly] =
      AwsError.unwrapOptionField("patchStatus", patchStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.EffectivePatch
  ) extends zio.aws.ssm.model.EffectivePatch.ReadOnly {
    override val patch: Option[zio.aws.ssm.model.Patch.ReadOnly] = scala
      .Option(impl.patch())
      .map(value => zio.aws.ssm.model.Patch.wrap(value))
    override val patchStatus: Option[zio.aws.ssm.model.PatchStatus.ReadOnly] =
      scala
        .Option(impl.patchStatus())
        .map(value => zio.aws.ssm.model.PatchStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.EffectivePatch
  ): zio.aws.ssm.model.EffectivePatch.ReadOnly = new Wrapper(impl)
}
