package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.SessionTarget
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetConnectionStatusRequest(target: SessionTarget) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetConnectionStatusRequest = {
    import GetConnectionStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetConnectionStatusRequest
      .builder()
      .target(SessionTarget.unwrap(target): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetConnectionStatusRequest.ReadOnly =
    zio.aws.ssm.model.GetConnectionStatusRequest.wrap(buildAwsValue())
}
object GetConnectionStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetConnectionStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetConnectionStatusRequest =
      zio.aws.ssm.model.GetConnectionStatusRequest(target)
    def target: SessionTarget
    def getTarget: ZIO[Any, Nothing, SessionTarget] = ZIO.succeed(target)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetConnectionStatusRequest
  ) extends zio.aws.ssm.model.GetConnectionStatusRequest.ReadOnly {
    override val target: SessionTarget =
      zio.aws.ssm.model.primitives.SessionTarget(impl.target())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetConnectionStatusRequest
  ): zio.aws.ssm.model.GetConnectionStatusRequest.ReadOnly = new Wrapper(impl)
}
