package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  DocumentVersion,
  DocumentVersionName,
  DocumentARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDocumentRequest(
    name: DocumentARN,
    versionName: Option[DocumentVersionName] = None,
    documentVersion: Option[DocumentVersion] = None,
    documentFormat: Option[zio.aws.ssm.model.DocumentFormat] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetDocumentRequest = {
    import GetDocumentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetDocumentRequest
      .builder()
      .name(DocumentARN.unwrap(name): java.lang.String)
      .optionallyWith(
        versionName.map(value =>
          DocumentVersionName.unwrap(value): java.lang.String
        )
      )(_.versionName)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(documentFormat.map(value => value.unwrap))(
        _.documentFormat
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetDocumentRequest.ReadOnly =
    zio.aws.ssm.model.GetDocumentRequest.wrap(buildAwsValue())
}
object GetDocumentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetDocumentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetDocumentRequest =
      zio.aws.ssm.model.GetDocumentRequest(
        name,
        versionName.map(value => value),
        documentVersion.map(value => value),
        documentFormat.map(value => value)
      )
    def name: DocumentARN
    def versionName: Option[DocumentVersionName]
    def documentVersion: Option[DocumentVersion]
    def documentFormat: Option[zio.aws.ssm.model.DocumentFormat]
    def getName: ZIO[Any, Nothing, DocumentARN] = ZIO.succeed(name)
    def getVersionName: ZIO[Any, AwsError, DocumentVersionName] =
      AwsError.unwrapOptionField("versionName", versionName)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getDocumentFormat
        : ZIO[Any, AwsError, zio.aws.ssm.model.DocumentFormat] =
      AwsError.unwrapOptionField("documentFormat", documentFormat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetDocumentRequest
  ) extends zio.aws.ssm.model.GetDocumentRequest.ReadOnly {
    override val name: DocumentARN =
      zio.aws.ssm.model.primitives.DocumentARN(impl.name())
    override val versionName: Option[DocumentVersionName] = scala
      .Option(impl.versionName())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersionName(value))
    override val documentVersion: Option[DocumentVersion] = scala
      .Option(impl.documentVersion())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val documentFormat: Option[zio.aws.ssm.model.DocumentFormat] =
      scala
        .Option(impl.documentFormat())
        .map(value => zio.aws.ssm.model.DocumentFormat.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetDocumentRequest
  ): zio.aws.ssm.model.GetDocumentRequest.ReadOnly = new Wrapper(impl)
}
