package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{MaxResults, NextToken}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetInventoryRequest(
    filters: Option[Iterable[zio.aws.ssm.model.InventoryFilter]] = None,
    aggregators: Option[Iterable[zio.aws.ssm.model.InventoryAggregator]] = None,
    resultAttributes: Option[Iterable[zio.aws.ssm.model.ResultAttribute]] =
      None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetInventoryRequest = {
    import GetInventoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetInventoryRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        aggregators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.aggregators)
      .optionallyWith(
        resultAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resultAttributes)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetInventoryRequest.ReadOnly =
    zio.aws.ssm.model.GetInventoryRequest.wrap(buildAwsValue())
}
object GetInventoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetInventoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetInventoryRequest =
      zio.aws.ssm.model.GetInventoryRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        aggregators.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resultAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filters: Option[List[zio.aws.ssm.model.InventoryFilter.ReadOnly]]
    def aggregators
        : Option[List[zio.aws.ssm.model.InventoryAggregator.ReadOnly]]
    def resultAttributes
        : Option[List[zio.aws.ssm.model.ResultAttribute.ReadOnly]]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.InventoryFilter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getAggregators: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.InventoryAggregator.ReadOnly
    ]] = AwsError.unwrapOptionField("aggregators", aggregators)
    def getResultAttributes
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.ResultAttribute.ReadOnly]] =
      AwsError.unwrapOptionField("resultAttributes", resultAttributes)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetInventoryRequest
  ) extends zio.aws.ssm.model.GetInventoryRequest.ReadOnly {
    override val filters
        : Option[List[zio.aws.ssm.model.InventoryFilter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.InventoryFilter.wrap(item)
        }.toList
      )
    override val aggregators
        : Option[List[zio.aws.ssm.model.InventoryAggregator.ReadOnly]] = scala
      .Option(impl.aggregators())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.InventoryAggregator.wrap(item)
        }.toList
      )
    override val resultAttributes
        : Option[List[zio.aws.ssm.model.ResultAttribute.ReadOnly]] = scala
      .Option(impl.resultAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.ResultAttribute.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetInventoryRequest
  ): zio.aws.ssm.model.GetInventoryRequest.ReadOnly = new Wrapper(impl)
}
