package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  MaintenanceWindowExecutionTaskInvocationId,
  MaintenanceWindowExecutionTaskId,
  MaintenanceWindowExecutionId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetMaintenanceWindowExecutionTaskInvocationRequest(
    windowExecutionId: MaintenanceWindowExecutionId,
    taskId: MaintenanceWindowExecutionTaskId,
    invocationId: MaintenanceWindowExecutionTaskInvocationId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskInvocationRequest = {
    import GetMaintenanceWindowExecutionTaskInvocationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskInvocationRequest
      .builder()
      .windowExecutionId(
        MaintenanceWindowExecutionId.unwrap(windowExecutionId): java.lang.String
      )
      .taskId(MaintenanceWindowExecutionTaskId.unwrap(taskId): java.lang.String)
      .invocationId(
        MaintenanceWindowExecutionTaskInvocationId.unwrap(
          invocationId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskInvocationRequest.ReadOnly =
    zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskInvocationRequest
      .wrap(buildAwsValue())
}
object GetMaintenanceWindowExecutionTaskInvocationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskInvocationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskInvocationRequest =
      zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskInvocationRequest(
        windowExecutionId,
        taskId,
        invocationId
      )
    def windowExecutionId: MaintenanceWindowExecutionId
    def taskId: MaintenanceWindowExecutionTaskId
    def invocationId: MaintenanceWindowExecutionTaskInvocationId
    def getWindowExecutionId: ZIO[Any, Nothing, MaintenanceWindowExecutionId] =
      ZIO.succeed(windowExecutionId)
    def getTaskId: ZIO[Any, Nothing, MaintenanceWindowExecutionTaskId] =
      ZIO.succeed(taskId)
    def getInvocationId
        : ZIO[Any, Nothing, MaintenanceWindowExecutionTaskInvocationId] =
      ZIO.succeed(invocationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskInvocationRequest
  ) extends zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskInvocationRequest.ReadOnly {
    override val windowExecutionId: MaintenanceWindowExecutionId =
      zio.aws.ssm.model.primitives
        .MaintenanceWindowExecutionId(impl.windowExecutionId())
    override val taskId: MaintenanceWindowExecutionTaskId =
      zio.aws.ssm.model.primitives
        .MaintenanceWindowExecutionTaskId(impl.taskId())
    override val invocationId: MaintenanceWindowExecutionTaskInvocationId =
      zio.aws.ssm.model.primitives
        .MaintenanceWindowExecutionTaskInvocationId(impl.invocationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskInvocationRequest
  ): zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskInvocationRequest.ReadOnly =
    new Wrapper(impl)
}
