package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.MaintenanceWindowId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetMaintenanceWindowRequest(windowId: MaintenanceWindowId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowRequest = {
    import GetMaintenanceWindowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowRequest
      .builder()
      .windowId(MaintenanceWindowId.unwrap(windowId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetMaintenanceWindowRequest.ReadOnly =
    zio.aws.ssm.model.GetMaintenanceWindowRequest.wrap(buildAwsValue())
}
object GetMaintenanceWindowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetMaintenanceWindowRequest =
      zio.aws.ssm.model.GetMaintenanceWindowRequest(windowId)
    def windowId: MaintenanceWindowId
    def getWindowId: ZIO[Any, Nothing, MaintenanceWindowId] =
      ZIO.succeed(windowId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowRequest
  ) extends zio.aws.ssm.model.GetMaintenanceWindowRequest.ReadOnly {
    override val windowId: MaintenanceWindowId =
      zio.aws.ssm.model.primitives.MaintenanceWindowId(impl.windowId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowRequest
  ): zio.aws.ssm.model.GetMaintenanceWindowRequest.ReadOnly = new Wrapper(impl)
}
