package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait InstancePatchStateOperatorType {
  def unwrap
      : software.amazon.awssdk.services.ssm.model.InstancePatchStateOperatorType
}
object InstancePatchStateOperatorType {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.InstancePatchStateOperatorType
  ): zio.aws.ssm.model.InstancePatchStateOperatorType = value match {
    case software.amazon.awssdk.services.ssm.model.InstancePatchStateOperatorType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.InstancePatchStateOperatorType.EQUAL =>
      val r = Equal
      r
    case software.amazon.awssdk.services.ssm.model.InstancePatchStateOperatorType.NOT_EQUAL =>
      val r = NotEqual
      r
    case software.amazon.awssdk.services.ssm.model.InstancePatchStateOperatorType.LESS_THAN =>
      val r = LessThan
      r
    case software.amazon.awssdk.services.ssm.model.InstancePatchStateOperatorType.GREATER_THAN =>
      val r = GreaterThan
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.InstancePatchStateOperatorType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InstancePatchStateOperatorType =
      software.amazon.awssdk.services.ssm.model.InstancePatchStateOperatorType.UNKNOWN_TO_SDK_VERSION
  }
  case object Equal extends zio.aws.ssm.model.InstancePatchStateOperatorType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InstancePatchStateOperatorType =
      software.amazon.awssdk.services.ssm.model.InstancePatchStateOperatorType.EQUAL
  }
  case object NotEqual
      extends zio.aws.ssm.model.InstancePatchStateOperatorType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InstancePatchStateOperatorType =
      software.amazon.awssdk.services.ssm.model.InstancePatchStateOperatorType.NOT_EQUAL
  }
  case object LessThan
      extends zio.aws.ssm.model.InstancePatchStateOperatorType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InstancePatchStateOperatorType =
      software.amazon.awssdk.services.ssm.model.InstancePatchStateOperatorType.LESS_THAN
  }
  case object GreaterThan
      extends zio.aws.ssm.model.InstancePatchStateOperatorType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InstancePatchStateOperatorType =
      software.amazon.awssdk.services.ssm.model.InstancePatchStateOperatorType.GREATER_THAN
  }
}
