package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{NextToken, MaxResults}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListAssociationsRequest(
    associationFilterList: Option[
      Iterable[zio.aws.ssm.model.AssociationFilter]
    ] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListAssociationsRequest = {
    import ListAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListAssociationsRequest
      .builder()
      .optionallyWith(
        associationFilterList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associationFilterList)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ListAssociationsRequest.ReadOnly =
    zio.aws.ssm.model.ListAssociationsRequest.wrap(buildAwsValue())
}
object ListAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListAssociationsRequest =
      zio.aws.ssm.model.ListAssociationsRequest(
        associationFilterList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def associationFilterList
        : Option[List[zio.aws.ssm.model.AssociationFilter.ReadOnly]]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getAssociationFilterList: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.AssociationFilter.ReadOnly
    ]] =
      AwsError.unwrapOptionField("associationFilterList", associationFilterList)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListAssociationsRequest
  ) extends zio.aws.ssm.model.ListAssociationsRequest.ReadOnly {
    override val associationFilterList
        : Option[List[zio.aws.ssm.model.AssociationFilter.ReadOnly]] = scala
      .Option(impl.associationFilterList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.AssociationFilter.wrap(item)
        }.toList
      )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListAssociationsRequest
  ): zio.aws.ssm.model.ListAssociationsRequest.ReadOnly = new Wrapper(impl)
}
