package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  MaxResults,
  NextToken,
  ComplianceResourceType,
  ComplianceResourceId
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListComplianceItemsRequest(
    filters: Option[Iterable[zio.aws.ssm.model.ComplianceStringFilter]] = None,
    resourceIds: Option[Iterable[ComplianceResourceId]] = None,
    resourceTypes: Option[Iterable[ComplianceResourceType]] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListComplianceItemsRequest = {
    import ListComplianceItemsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListComplianceItemsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        resourceIds.map(value =>
          value.map { item =>
            ComplianceResourceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resourceIds)
      .optionallyWith(
        resourceTypes.map(value =>
          value.map { item =>
            ComplianceResourceType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resourceTypes)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ListComplianceItemsRequest.ReadOnly =
    zio.aws.ssm.model.ListComplianceItemsRequest.wrap(buildAwsValue())
}
object ListComplianceItemsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListComplianceItemsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListComplianceItemsRequest =
      zio.aws.ssm.model.ListComplianceItemsRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceIds.map(value => value),
        resourceTypes.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filters: Option[List[zio.aws.ssm.model.ComplianceStringFilter.ReadOnly]]
    def resourceIds: Option[List[ComplianceResourceId]]
    def resourceTypes: Option[List[ComplianceResourceType]]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.ComplianceStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getResourceIds: ZIO[Any, AwsError, List[ComplianceResourceId]] =
      AwsError.unwrapOptionField("resourceIds", resourceIds)
    def getResourceTypes: ZIO[Any, AwsError, List[ComplianceResourceType]] =
      AwsError.unwrapOptionField("resourceTypes", resourceTypes)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListComplianceItemsRequest
  ) extends zio.aws.ssm.model.ListComplianceItemsRequest.ReadOnly {
    override val filters
        : Option[List[zio.aws.ssm.model.ComplianceStringFilter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.ComplianceStringFilter.wrap(item)
          }.toList
        )
    override val resourceIds: Option[List[ComplianceResourceId]] = scala
      .Option(impl.resourceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.ComplianceResourceId(item)
        }.toList
      )
    override val resourceTypes: Option[List[ComplianceResourceType]] = scala
      .Option(impl.resourceTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.ComplianceResourceType(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListComplianceItemsRequest
  ): zio.aws.ssm.model.ListComplianceItemsRequest.ReadOnly = new Wrapper(impl)
}
