package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{MaxResults, NextToken}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListResourceComplianceSummariesRequest(
    filters: Option[Iterable[zio.aws.ssm.model.ComplianceStringFilter]] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesRequest = {
    import ListResourceComplianceSummariesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.ListResourceComplianceSummariesRequest.ReadOnly =
    zio.aws.ssm.model.ListResourceComplianceSummariesRequest
      .wrap(buildAwsValue())
}
object ListResourceComplianceSummariesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListResourceComplianceSummariesRequest =
      zio.aws.ssm.model.ListResourceComplianceSummariesRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filters: Option[List[zio.aws.ssm.model.ComplianceStringFilter.ReadOnly]]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.ComplianceStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesRequest
  ) extends zio.aws.ssm.model.ListResourceComplianceSummariesRequest.ReadOnly {
    override val filters
        : Option[List[zio.aws.ssm.model.ComplianceStringFilter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.ComplianceStringFilter.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesRequest
  ): zio.aws.ssm.model.ListResourceComplianceSummariesRequest.ReadOnly =
    new Wrapper(impl)
}
