package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{S3Region, S3KeyPrefix, S3BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LoggingInfo(
    s3BucketName: S3BucketName,
    s3KeyPrefix: Option[S3KeyPrefix] = None,
    s3Region: S3Region
) {
  def buildAwsValue(): software.amazon.awssdk.services.ssm.model.LoggingInfo = {
    import LoggingInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.LoggingInfo
      .builder()
      .s3BucketName(S3BucketName.unwrap(s3BucketName): java.lang.String)
      .optionallyWith(
        s3KeyPrefix.map(value => S3KeyPrefix.unwrap(value): java.lang.String)
      )(_.s3KeyPrefix)
      .s3Region(S3Region.unwrap(s3Region): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.LoggingInfo.ReadOnly =
    zio.aws.ssm.model.LoggingInfo.wrap(buildAwsValue())
}
object LoggingInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.LoggingInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.LoggingInfo = zio.aws.ssm.model
      .LoggingInfo(s3BucketName, s3KeyPrefix.map(value => value), s3Region)
    def s3BucketName: S3BucketName
    def s3KeyPrefix: Option[S3KeyPrefix]
    def s3Region: S3Region
    def getS3BucketName: ZIO[Any, Nothing, S3BucketName] =
      ZIO.succeed(s3BucketName)
    def getS3KeyPrefix: ZIO[Any, AwsError, S3KeyPrefix] =
      AwsError.unwrapOptionField("s3KeyPrefix", s3KeyPrefix)
    def getS3Region: ZIO[Any, Nothing, S3Region] = ZIO.succeed(s3Region)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.LoggingInfo
  ) extends zio.aws.ssm.model.LoggingInfo.ReadOnly {
    override val s3BucketName: S3BucketName =
      zio.aws.ssm.model.primitives.S3BucketName(impl.s3BucketName())
    override val s3KeyPrefix: Option[S3KeyPrefix] = scala
      .Option(impl.s3KeyPrefix())
      .map(value => zio.aws.ssm.model.primitives.S3KeyPrefix(value))
    override val s3Region: S3Region =
      zio.aws.ssm.model.primitives.S3Region(impl.s3Region())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.LoggingInfo
  ): zio.aws.ssm.model.LoggingInfo.ReadOnly = new Wrapper(impl)
}
