package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait MaintenanceWindowExecutionStatus {
  def unwrap: software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus
}
object MaintenanceWindowExecutionStatus {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus
  ): zio.aws.ssm.model.MaintenanceWindowExecutionStatus = value match {
    case software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus.TIMED_OUT =>
      val r = TIMED_OUT
      r
    case software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus.CANCELLING =>
      val r = CANCELLING
      r
    case software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus.CANCELLED =>
      val r = CANCELLED
      r
    case software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus.SKIPPED_OVERLAPPING =>
      val r = SKIPPED_OVERLAPPING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.MaintenanceWindowExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus =
      software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING
      extends zio.aws.ssm.model.MaintenanceWindowExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus =
      software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus.PENDING
  }
  case object IN_PROGRESS
      extends zio.aws.ssm.model.MaintenanceWindowExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus =
      software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus.IN_PROGRESS
  }
  case object SUCCESS
      extends zio.aws.ssm.model.MaintenanceWindowExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus =
      software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus.SUCCESS
  }
  case object FAILED
      extends zio.aws.ssm.model.MaintenanceWindowExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus =
      software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus.FAILED
  }
  case object TIMED_OUT
      extends zio.aws.ssm.model.MaintenanceWindowExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus =
      software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus.TIMED_OUT
  }
  case object CANCELLING
      extends zio.aws.ssm.model.MaintenanceWindowExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus =
      software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus.CANCELLING
  }
  case object CANCELLED
      extends zio.aws.ssm.model.MaintenanceWindowExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus =
      software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus.CANCELLED
  }
  case object SKIPPED_OVERLAPPING
      extends zio.aws.ssm.model.MaintenanceWindowExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus =
      software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus.SKIPPED_OVERLAPPING
  }
}
