package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  MaintenanceWindowTaskParameterName,
  MaintenanceWindowTaskPriority,
  MaintenanceWindowId,
  MaintenanceWindowTaskArn,
  MaintenanceWindowTaskId,
  ServiceRole,
  MaxConcurrency,
  MaintenanceWindowName,
  MaxErrors,
  MaintenanceWindowDescription
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class MaintenanceWindowTask(
    windowId: Option[MaintenanceWindowId] = None,
    windowTaskId: Option[MaintenanceWindowTaskId] = None,
    taskArn: Option[MaintenanceWindowTaskArn] = None,
    `type`: Option[zio.aws.ssm.model.MaintenanceWindowTaskType] = None,
    targets: Option[Iterable[zio.aws.ssm.model.Target]] = None,
    taskParameters: Option[Map[
      MaintenanceWindowTaskParameterName,
      zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression
    ]] = None,
    priority: Option[MaintenanceWindowTaskPriority] = None,
    loggingInfo: Option[zio.aws.ssm.model.LoggingInfo] = None,
    serviceRoleArn: Option[ServiceRole] = None,
    maxConcurrency: Option[MaxConcurrency] = None,
    maxErrors: Option[MaxErrors] = None,
    name: Option[MaintenanceWindowName] = None,
    description: Option[MaintenanceWindowDescription] = None,
    cutoffBehavior: Option[
      zio.aws.ssm.model.MaintenanceWindowTaskCutoffBehavior
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.MaintenanceWindowTask = {
    import MaintenanceWindowTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.MaintenanceWindowTask
      .builder()
      .optionallyWith(
        windowId.map(value =>
          MaintenanceWindowId.unwrap(value): java.lang.String
        )
      )(_.windowId)
      .optionallyWith(
        windowTaskId.map(value =>
          MaintenanceWindowTaskId.unwrap(value): java.lang.String
        )
      )(_.windowTaskId)
      .optionallyWith(
        taskArn.map(value =>
          MaintenanceWindowTaskArn.unwrap(value): java.lang.String
        )
      )(_.taskArn)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(
        taskParameters.map(value =>
          value
            .map({ case (key, value) =>
              (MaintenanceWindowTaskParameterName.unwrap(
                key
              ): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.taskParameters)
      .optionallyWith(
        priority.map(value =>
          MaintenanceWindowTaskPriority.unwrap(value): Integer
        )
      )(_.priority)
      .optionallyWith(loggingInfo.map(value => value.buildAwsValue()))(
        _.loggingInfo
      )
      .optionallyWith(
        serviceRoleArn.map(value => ServiceRole.unwrap(value): java.lang.String)
      )(_.serviceRoleArn)
      .optionallyWith(
        maxConcurrency.map(value =>
          MaxConcurrency.unwrap(value): java.lang.String
        )
      )(_.maxConcurrency)
      .optionallyWith(
        maxErrors.map(value => MaxErrors.unwrap(value): java.lang.String)
      )(_.maxErrors)
      .optionallyWith(
        name.map(value => MaintenanceWindowName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          MaintenanceWindowDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(cutoffBehavior.map(value => value.unwrap))(
        _.cutoffBehavior
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.MaintenanceWindowTask.ReadOnly =
    zio.aws.ssm.model.MaintenanceWindowTask.wrap(buildAwsValue())
}
object MaintenanceWindowTask {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.MaintenanceWindowTask
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.MaintenanceWindowTask =
      zio.aws.ssm.model.MaintenanceWindowTask(
        windowId.map(value => value),
        windowTaskId.map(value => value),
        taskArn.map(value => value),
        `type`.map(value => value),
        targets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        taskParameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        priority.map(value => value),
        loggingInfo.map(value => value.asEditable),
        serviceRoleArn.map(value => value),
        maxConcurrency.map(value => value),
        maxErrors.map(value => value),
        name.map(value => value),
        description.map(value => value),
        cutoffBehavior.map(value => value)
      )
    def windowId: Option[MaintenanceWindowId]
    def windowTaskId: Option[MaintenanceWindowTaskId]
    def taskArn: Option[MaintenanceWindowTaskArn]
    def `type`: Option[zio.aws.ssm.model.MaintenanceWindowTaskType]
    def targets: Option[List[zio.aws.ssm.model.Target.ReadOnly]]
    def taskParameters: Option[Map[
      MaintenanceWindowTaskParameterName,
      zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression.ReadOnly
    ]]
    def priority: Option[MaintenanceWindowTaskPriority]
    def loggingInfo: Option[zio.aws.ssm.model.LoggingInfo.ReadOnly]
    def serviceRoleArn: Option[ServiceRole]
    def maxConcurrency: Option[MaxConcurrency]
    def maxErrors: Option[MaxErrors]
    def name: Option[MaintenanceWindowName]
    def description: Option[MaintenanceWindowDescription]
    def cutoffBehavior
        : Option[zio.aws.ssm.model.MaintenanceWindowTaskCutoffBehavior]
    def getWindowId: ZIO[Any, AwsError, MaintenanceWindowId] =
      AwsError.unwrapOptionField("windowId", windowId)
    def getWindowTaskId: ZIO[Any, AwsError, MaintenanceWindowTaskId] =
      AwsError.unwrapOptionField("windowTaskId", windowTaskId)
    def getTaskArn: ZIO[Any, AwsError, MaintenanceWindowTaskArn] =
      AwsError.unwrapOptionField("taskArn", taskArn)
    def getType
        : ZIO[Any, AwsError, zio.aws.ssm.model.MaintenanceWindowTaskType] =
      AwsError.unwrapOptionField("type", `type`)
    def getTargets
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Target.ReadOnly]] =
      AwsError.unwrapOptionField("targets", targets)
    def getTaskParameters: ZIO[Any, AwsError, Map[
      MaintenanceWindowTaskParameterName,
      zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression.ReadOnly
    ]] = AwsError.unwrapOptionField("taskParameters", taskParameters)
    def getPriority: ZIO[Any, AwsError, MaintenanceWindowTaskPriority] =
      AwsError.unwrapOptionField("priority", priority)
    def getLoggingInfo
        : ZIO[Any, AwsError, zio.aws.ssm.model.LoggingInfo.ReadOnly] =
      AwsError.unwrapOptionField("loggingInfo", loggingInfo)
    def getServiceRoleArn: ZIO[Any, AwsError, ServiceRole] =
      AwsError.unwrapOptionField("serviceRoleArn", serviceRoleArn)
    def getMaxConcurrency: ZIO[Any, AwsError, MaxConcurrency] =
      AwsError.unwrapOptionField("maxConcurrency", maxConcurrency)
    def getMaxErrors: ZIO[Any, AwsError, MaxErrors] =
      AwsError.unwrapOptionField("maxErrors", maxErrors)
    def getName: ZIO[Any, AwsError, MaintenanceWindowName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, MaintenanceWindowDescription] =
      AwsError.unwrapOptionField("description", description)
    def getCutoffBehavior: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.MaintenanceWindowTaskCutoffBehavior
    ] = AwsError.unwrapOptionField("cutoffBehavior", cutoffBehavior)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.MaintenanceWindowTask
  ) extends zio.aws.ssm.model.MaintenanceWindowTask.ReadOnly {
    override val windowId: Option[MaintenanceWindowId] = scala
      .Option(impl.windowId())
      .map(value => zio.aws.ssm.model.primitives.MaintenanceWindowId(value))
    override val windowTaskId: Option[MaintenanceWindowTaskId] = scala
      .Option(impl.windowTaskId())
      .map(value => zio.aws.ssm.model.primitives.MaintenanceWindowTaskId(value))
    override val taskArn: Option[MaintenanceWindowTaskArn] = scala
      .Option(impl.taskArn())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowTaskArn(value)
      )
    override val `type`: Option[zio.aws.ssm.model.MaintenanceWindowTaskType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.ssm.model.MaintenanceWindowTaskType.wrap(value))
    override val targets: Option[List[zio.aws.ssm.model.Target.ReadOnly]] =
      scala
        .Option(impl.targets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Target.wrap(item)
          }.toList
        )
    override val taskParameters: Option[Map[
      MaintenanceWindowTaskParameterName,
      zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression.ReadOnly
    ]] = scala
      .Option(impl.taskParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssm.model.primitives.MaintenanceWindowTaskParameterName(
              key
            ) -> zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression
              .wrap(value)
          })
          .toMap
      )
    override val priority: Option[MaintenanceWindowTaskPriority] = scala
      .Option(impl.priority())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowTaskPriority(value)
      )
    override val loggingInfo: Option[zio.aws.ssm.model.LoggingInfo.ReadOnly] =
      scala
        .Option(impl.loggingInfo())
        .map(value => zio.aws.ssm.model.LoggingInfo.wrap(value))
    override val serviceRoleArn: Option[ServiceRole] = scala
      .Option(impl.serviceRoleArn())
      .map(value => zio.aws.ssm.model.primitives.ServiceRole(value))
    override val maxConcurrency: Option[MaxConcurrency] = scala
      .Option(impl.maxConcurrency())
      .map(value => zio.aws.ssm.model.primitives.MaxConcurrency(value))
    override val maxErrors: Option[MaxErrors] = scala
      .Option(impl.maxErrors())
      .map(value => zio.aws.ssm.model.primitives.MaxErrors(value))
    override val name: Option[MaintenanceWindowName] = scala
      .Option(impl.name())
      .map(value => zio.aws.ssm.model.primitives.MaintenanceWindowName(value))
    override val description: Option[MaintenanceWindowDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowDescription(value)
      )
    override val cutoffBehavior
        : Option[zio.aws.ssm.model.MaintenanceWindowTaskCutoffBehavior] = scala
      .Option(impl.cutoffBehavior())
      .map(value =>
        zio.aws.ssm.model.MaintenanceWindowTaskCutoffBehavior.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.MaintenanceWindowTask
  ): zio.aws.ssm.model.MaintenanceWindowTask.ReadOnly = new Wrapper(impl)
}
