package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait MaintenanceWindowTaskCutoffBehavior {
  def unwrap: software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskCutoffBehavior
}
object MaintenanceWindowTaskCutoffBehavior {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskCutoffBehavior
  ): zio.aws.ssm.model.MaintenanceWindowTaskCutoffBehavior = value match {
    case software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskCutoffBehavior.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskCutoffBehavior.CONTINUE_TASK =>
      val r = CONTINUE_TASK
      r
    case software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskCutoffBehavior.CANCEL_TASK =>
      val r = CANCEL_TASK
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.MaintenanceWindowTaskCutoffBehavior {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskCutoffBehavior =
      software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskCutoffBehavior.UNKNOWN_TO_SDK_VERSION
  }
  case object CONTINUE_TASK
      extends zio.aws.ssm.model.MaintenanceWindowTaskCutoffBehavior {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskCutoffBehavior =
      software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskCutoffBehavior.CONTINUE_TASK
  }
  case object CANCEL_TASK
      extends zio.aws.ssm.model.MaintenanceWindowTaskCutoffBehavior {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskCutoffBehavior =
      software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskCutoffBehavior.CANCEL_TASK
  }
}
