package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.ComplianceSummaryCount
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class NonCompliantSummary(
    nonCompliantCount: Option[ComplianceSummaryCount] = None,
    severitySummary: Option[zio.aws.ssm.model.SeveritySummary] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.NonCompliantSummary = {
    import NonCompliantSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.NonCompliantSummary
      .builder()
      .optionallyWith(
        nonCompliantCount.map(value =>
          ComplianceSummaryCount.unwrap(value): Integer
        )
      )(_.nonCompliantCount)
      .optionallyWith(severitySummary.map(value => value.buildAwsValue()))(
        _.severitySummary
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.NonCompliantSummary.ReadOnly =
    zio.aws.ssm.model.NonCompliantSummary.wrap(buildAwsValue())
}
object NonCompliantSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.NonCompliantSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.NonCompliantSummary =
      zio.aws.ssm.model.NonCompliantSummary(
        nonCompliantCount.map(value => value),
        severitySummary.map(value => value.asEditable)
      )
    def nonCompliantCount: Option[ComplianceSummaryCount]
    def severitySummary: Option[zio.aws.ssm.model.SeveritySummary.ReadOnly]
    def getNonCompliantCount: ZIO[Any, AwsError, ComplianceSummaryCount] =
      AwsError.unwrapOptionField("nonCompliantCount", nonCompliantCount)
    def getSeveritySummary
        : ZIO[Any, AwsError, zio.aws.ssm.model.SeveritySummary.ReadOnly] =
      AwsError.unwrapOptionField("severitySummary", severitySummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.NonCompliantSummary
  ) extends zio.aws.ssm.model.NonCompliantSummary.ReadOnly {
    override val nonCompliantCount: Option[ComplianceSummaryCount] = scala
      .Option(impl.nonCompliantCount())
      .map(value => zio.aws.ssm.model.primitives.ComplianceSummaryCount(value))
    override val severitySummary
        : Option[zio.aws.ssm.model.SeveritySummary.ReadOnly] = scala
      .Option(impl.severitySummary())
      .map(value => zio.aws.ssm.model.SeveritySummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.NonCompliantSummary
  ): zio.aws.ssm.model.NonCompliantSummary.ReadOnly = new Wrapper(impl)
}
