package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait OpsItemStatus {
  def unwrap: software.amazon.awssdk.services.ssm.model.OpsItemStatus
}
object OpsItemStatus {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.OpsItemStatus
  ): zio.aws.ssm.model.OpsItemStatus = value match {
    case software.amazon.awssdk.services.ssm.model.OpsItemStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemStatus.OPEN =>
      val r = Open
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemStatus.RESOLVED =>
      val r = Resolved
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemStatus.TIMED_OUT =>
      val r = TimedOut
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemStatus.CANCELLING =>
      val r = Cancelling
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemStatus.CANCELLED =>
      val r = Cancelled
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemStatus.COMPLETED_WITH_SUCCESS =>
      val r = CompletedWithSuccess
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemStatus.COMPLETED_WITH_FAILURE =>
      val r = CompletedWithFailure
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemStatus.SCHEDULED =>
      val r = Scheduled
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemStatus.RUNBOOK_IN_PROGRESS =>
      val r = RunbookInProgress
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemStatus.PENDING_CHANGE_CALENDAR_OVERRIDE =>
      val r = PendingChangeCalendarOverride
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemStatus.CHANGE_CALENDAR_OVERRIDE_APPROVED =>
      val r = ChangeCalendarOverrideApproved
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemStatus.CHANGE_CALENDAR_OVERRIDE_REJECTED =>
      val r = ChangeCalendarOverrideRejected
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemStatus.PENDING_APPROVAL =>
      val r = PendingApproval
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemStatus.APPROVED =>
      val r = Approved
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemStatus.REJECTED =>
      val r = Rejected
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemStatus.CLOSED =>
      val r = Closed
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.OpsItemStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemStatus =
      software.amazon.awssdk.services.ssm.model.OpsItemStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Open extends zio.aws.ssm.model.OpsItemStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemStatus =
      software.amazon.awssdk.services.ssm.model.OpsItemStatus.OPEN
  }
  case object InProgress extends zio.aws.ssm.model.OpsItemStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemStatus =
      software.amazon.awssdk.services.ssm.model.OpsItemStatus.IN_PROGRESS
  }
  case object Resolved extends zio.aws.ssm.model.OpsItemStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemStatus =
      software.amazon.awssdk.services.ssm.model.OpsItemStatus.RESOLVED
  }
  case object Pending extends zio.aws.ssm.model.OpsItemStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemStatus =
      software.amazon.awssdk.services.ssm.model.OpsItemStatus.PENDING
  }
  case object TimedOut extends zio.aws.ssm.model.OpsItemStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemStatus =
      software.amazon.awssdk.services.ssm.model.OpsItemStatus.TIMED_OUT
  }
  case object Cancelling extends zio.aws.ssm.model.OpsItemStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemStatus =
      software.amazon.awssdk.services.ssm.model.OpsItemStatus.CANCELLING
  }
  case object Cancelled extends zio.aws.ssm.model.OpsItemStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemStatus =
      software.amazon.awssdk.services.ssm.model.OpsItemStatus.CANCELLED
  }
  case object Failed extends zio.aws.ssm.model.OpsItemStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemStatus =
      software.amazon.awssdk.services.ssm.model.OpsItemStatus.FAILED
  }
  case object CompletedWithSuccess extends zio.aws.ssm.model.OpsItemStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemStatus =
      software.amazon.awssdk.services.ssm.model.OpsItemStatus.COMPLETED_WITH_SUCCESS
  }
  case object CompletedWithFailure extends zio.aws.ssm.model.OpsItemStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemStatus =
      software.amazon.awssdk.services.ssm.model.OpsItemStatus.COMPLETED_WITH_FAILURE
  }
  case object Scheduled extends zio.aws.ssm.model.OpsItemStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemStatus =
      software.amazon.awssdk.services.ssm.model.OpsItemStatus.SCHEDULED
  }
  case object RunbookInProgress extends zio.aws.ssm.model.OpsItemStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemStatus =
      software.amazon.awssdk.services.ssm.model.OpsItemStatus.RUNBOOK_IN_PROGRESS
  }
  case object PendingChangeCalendarOverride
      extends zio.aws.ssm.model.OpsItemStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemStatus =
      software.amazon.awssdk.services.ssm.model.OpsItemStatus.PENDING_CHANGE_CALENDAR_OVERRIDE
  }
  case object ChangeCalendarOverrideApproved
      extends zio.aws.ssm.model.OpsItemStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemStatus =
      software.amazon.awssdk.services.ssm.model.OpsItemStatus.CHANGE_CALENDAR_OVERRIDE_APPROVED
  }
  case object ChangeCalendarOverrideRejected
      extends zio.aws.ssm.model.OpsItemStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemStatus =
      software.amazon.awssdk.services.ssm.model.OpsItemStatus.CHANGE_CALENDAR_OVERRIDE_REJECTED
  }
  case object PendingApproval extends zio.aws.ssm.model.OpsItemStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemStatus =
      software.amazon.awssdk.services.ssm.model.OpsItemStatus.PENDING_APPROVAL
  }
  case object Approved extends zio.aws.ssm.model.OpsItemStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemStatus =
      software.amazon.awssdk.services.ssm.model.OpsItemStatus.APPROVED
  }
  case object Rejected extends zio.aws.ssm.model.OpsItemStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemStatus =
      software.amazon.awssdk.services.ssm.model.OpsItemStatus.REJECTED
  }
  case object Closed extends zio.aws.ssm.model.OpsItemStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemStatus =
      software.amazon.awssdk.services.ssm.model.OpsItemStatus.CLOSED
  }
}
