package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ParameterInlinePolicy(
    policyText: Option[String] = None,
    policyType: Option[String] = None,
    policyStatus: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ParameterInlinePolicy = {
    import ParameterInlinePolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ParameterInlinePolicy
      .builder()
      .optionallyWith(policyText.map(value => value: java.lang.String))(
        _.policyText
      )
      .optionallyWith(policyType.map(value => value: java.lang.String))(
        _.policyType
      )
      .optionallyWith(policyStatus.map(value => value: java.lang.String))(
        _.policyStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ParameterInlinePolicy.ReadOnly =
    zio.aws.ssm.model.ParameterInlinePolicy.wrap(buildAwsValue())
}
object ParameterInlinePolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ParameterInlinePolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ParameterInlinePolicy =
      zio.aws.ssm.model.ParameterInlinePolicy(
        policyText.map(value => value),
        policyType.map(value => value),
        policyStatus.map(value => value)
      )
    def policyText: Option[String]
    def policyType: Option[String]
    def policyStatus: Option[String]
    def getPolicyText: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policyText", policyText)
    def getPolicyType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policyType", policyType)
    def getPolicyStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policyStatus", policyStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ParameterInlinePolicy
  ) extends zio.aws.ssm.model.ParameterInlinePolicy.ReadOnly {
    override val policyText: Option[String] =
      scala.Option(impl.policyText()).map(value => value: String)
    override val policyType: Option[String] =
      scala.Option(impl.policyType()).map(value => value: String)
    override val policyStatus: Option[String] =
      scala.Option(impl.policyStatus()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ParameterInlinePolicy
  ): zio.aws.ssm.model.ParameterInlinePolicy.ReadOnly = new Wrapper(impl)
}
