package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.DateTime
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class PatchStatus(
    deploymentStatus: Option[zio.aws.ssm.model.PatchDeploymentStatus] = None,
    complianceLevel: Option[zio.aws.ssm.model.PatchComplianceLevel] = None,
    approvalDate: Option[DateTime] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ssm.model.PatchStatus = {
    import PatchStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.PatchStatus
      .builder()
      .optionallyWith(deploymentStatus.map(value => value.unwrap))(
        _.deploymentStatus
      )
      .optionallyWith(complianceLevel.map(value => value.unwrap))(
        _.complianceLevel
      )
      .optionallyWith(
        approvalDate.map(value => DateTime.unwrap(value): Instant)
      )(_.approvalDate)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.PatchStatus.ReadOnly =
    zio.aws.ssm.model.PatchStatus.wrap(buildAwsValue())
}
object PatchStatus {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.PatchStatus] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.PatchStatus =
      zio.aws.ssm.model.PatchStatus(
        deploymentStatus.map(value => value),
        complianceLevel.map(value => value),
        approvalDate.map(value => value)
      )
    def deploymentStatus: Option[zio.aws.ssm.model.PatchDeploymentStatus]
    def complianceLevel: Option[zio.aws.ssm.model.PatchComplianceLevel]
    def approvalDate: Option[DateTime]
    def getDeploymentStatus
        : ZIO[Any, AwsError, zio.aws.ssm.model.PatchDeploymentStatus] =
      AwsError.unwrapOptionField("deploymentStatus", deploymentStatus)
    def getComplianceLevel
        : ZIO[Any, AwsError, zio.aws.ssm.model.PatchComplianceLevel] =
      AwsError.unwrapOptionField("complianceLevel", complianceLevel)
    def getApprovalDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("approvalDate", approvalDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.PatchStatus
  ) extends zio.aws.ssm.model.PatchStatus.ReadOnly {
    override val deploymentStatus
        : Option[zio.aws.ssm.model.PatchDeploymentStatus] = scala
      .Option(impl.deploymentStatus())
      .map(value => zio.aws.ssm.model.PatchDeploymentStatus.wrap(value))
    override val complianceLevel
        : Option[zio.aws.ssm.model.PatchComplianceLevel] = scala
      .Option(impl.complianceLevel())
      .map(value => zio.aws.ssm.model.PatchComplianceLevel.wrap(value))
    override val approvalDate: Option[DateTime] = scala
      .Option(impl.approvalDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.PatchStatus
  ): zio.aws.ssm.model.PatchStatus.ReadOnly = new Wrapper(impl)
}
