package zio.aws.ssm.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ProgressCounters(
    totalSteps: Option[zio.aws.ssm.model.primitives.Integer] = None,
    successSteps: Option[zio.aws.ssm.model.primitives.Integer] = None,
    failedSteps: Option[zio.aws.ssm.model.primitives.Integer] = None,
    cancelledSteps: Option[zio.aws.ssm.model.primitives.Integer] = None,
    timedOutSteps: Option[zio.aws.ssm.model.primitives.Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ProgressCounters = {
    import ProgressCounters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ProgressCounters
      .builder()
      .optionallyWith(
        totalSteps.map(value =>
          zio.aws.ssm.model.primitives.Integer.unwrap(value): Integer
        )
      )(_.totalSteps)
      .optionallyWith(
        successSteps.map(value =>
          zio.aws.ssm.model.primitives.Integer.unwrap(value): Integer
        )
      )(_.successSteps)
      .optionallyWith(
        failedSteps.map(value =>
          zio.aws.ssm.model.primitives.Integer.unwrap(value): Integer
        )
      )(_.failedSteps)
      .optionallyWith(
        cancelledSteps.map(value =>
          zio.aws.ssm.model.primitives.Integer.unwrap(value): Integer
        )
      )(_.cancelledSteps)
      .optionallyWith(
        timedOutSteps.map(value =>
          zio.aws.ssm.model.primitives.Integer.unwrap(value): Integer
        )
      )(_.timedOutSteps)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ProgressCounters.ReadOnly =
    zio.aws.ssm.model.ProgressCounters.wrap(buildAwsValue())
}
object ProgressCounters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ProgressCounters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ProgressCounters =
      zio.aws.ssm.model.ProgressCounters(
        totalSteps.map(value => value),
        successSteps.map(value => value),
        failedSteps.map(value => value),
        cancelledSteps.map(value => value),
        timedOutSteps.map(value => value)
      )
    def totalSteps: Option[zio.aws.ssm.model.primitives.Integer]
    def successSteps: Option[zio.aws.ssm.model.primitives.Integer]
    def failedSteps: Option[zio.aws.ssm.model.primitives.Integer]
    def cancelledSteps: Option[zio.aws.ssm.model.primitives.Integer]
    def timedOutSteps: Option[zio.aws.ssm.model.primitives.Integer]
    def getTotalSteps
        : ZIO[Any, AwsError, zio.aws.ssm.model.primitives.Integer] =
      AwsError.unwrapOptionField("totalSteps", totalSteps)
    def getSuccessSteps
        : ZIO[Any, AwsError, zio.aws.ssm.model.primitives.Integer] =
      AwsError.unwrapOptionField("successSteps", successSteps)
    def getFailedSteps
        : ZIO[Any, AwsError, zio.aws.ssm.model.primitives.Integer] =
      AwsError.unwrapOptionField("failedSteps", failedSteps)
    def getCancelledSteps
        : ZIO[Any, AwsError, zio.aws.ssm.model.primitives.Integer] =
      AwsError.unwrapOptionField("cancelledSteps", cancelledSteps)
    def getTimedOutSteps
        : ZIO[Any, AwsError, zio.aws.ssm.model.primitives.Integer] =
      AwsError.unwrapOptionField("timedOutSteps", timedOutSteps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ProgressCounters
  ) extends zio.aws.ssm.model.ProgressCounters.ReadOnly {
    override val totalSteps: Option[zio.aws.ssm.model.primitives.Integer] =
      scala
        .Option(impl.totalSteps())
        .map(value => zio.aws.ssm.model.primitives.Integer(value))
    override val successSteps: Option[zio.aws.ssm.model.primitives.Integer] =
      scala
        .Option(impl.successSteps())
        .map(value => zio.aws.ssm.model.primitives.Integer(value))
    override val failedSteps: Option[zio.aws.ssm.model.primitives.Integer] =
      scala
        .Option(impl.failedSteps())
        .map(value => zio.aws.ssm.model.primitives.Integer(value))
    override val cancelledSteps: Option[zio.aws.ssm.model.primitives.Integer] =
      scala
        .Option(impl.cancelledSteps())
        .map(value => zio.aws.ssm.model.primitives.Integer(value))
    override val timedOutSteps: Option[zio.aws.ssm.model.primitives.Integer] =
      scala
        .Option(impl.timedOutSteps())
        .map(value => zio.aws.ssm.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ProgressCounters
  ): zio.aws.ssm.model.ProgressCounters.ReadOnly = new Wrapper(impl)
}
