package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  ComplianceItemContentHash,
  ComplianceTypeName,
  ComplianceResourceType,
  ComplianceResourceId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutComplianceItemsRequest(
    resourceId: ComplianceResourceId,
    resourceType: ComplianceResourceType,
    complianceType: ComplianceTypeName,
    executionSummary: zio.aws.ssm.model.ComplianceExecutionSummary,
    items: Iterable[zio.aws.ssm.model.ComplianceItemEntry],
    itemContentHash: Option[ComplianceItemContentHash] = None,
    uploadType: Option[zio.aws.ssm.model.ComplianceUploadType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.PutComplianceItemsRequest = {
    import PutComplianceItemsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.PutComplianceItemsRequest
      .builder()
      .resourceId(ComplianceResourceId.unwrap(resourceId): java.lang.String)
      .resourceType(
        ComplianceResourceType.unwrap(resourceType): java.lang.String
      )
      .complianceType(
        ComplianceTypeName.unwrap(complianceType): java.lang.String
      )
      .executionSummary(executionSummary.buildAwsValue())
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        itemContentHash.map(value =>
          ComplianceItemContentHash.unwrap(value): java.lang.String
        )
      )(_.itemContentHash)
      .optionallyWith(uploadType.map(value => value.unwrap))(_.uploadType)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.PutComplianceItemsRequest.ReadOnly =
    zio.aws.ssm.model.PutComplianceItemsRequest.wrap(buildAwsValue())
}
object PutComplianceItemsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.PutComplianceItemsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.PutComplianceItemsRequest =
      zio.aws.ssm.model.PutComplianceItemsRequest(
        resourceId,
        resourceType,
        complianceType,
        executionSummary.asEditable,
        items.map { item =>
          item.asEditable
        },
        itemContentHash.map(value => value),
        uploadType.map(value => value)
      )
    def resourceId: ComplianceResourceId
    def resourceType: ComplianceResourceType
    def complianceType: ComplianceTypeName
    def executionSummary: zio.aws.ssm.model.ComplianceExecutionSummary.ReadOnly
    def items: List[zio.aws.ssm.model.ComplianceItemEntry.ReadOnly]
    def itemContentHash: Option[ComplianceItemContentHash]
    def uploadType: Option[zio.aws.ssm.model.ComplianceUploadType]
    def getResourceId: ZIO[Any, Nothing, ComplianceResourceId] =
      ZIO.succeed(resourceId)
    def getResourceType: ZIO[Any, Nothing, ComplianceResourceType] =
      ZIO.succeed(resourceType)
    def getComplianceType: ZIO[Any, Nothing, ComplianceTypeName] =
      ZIO.succeed(complianceType)
    def getExecutionSummary: ZIO[
      Any,
      Nothing,
      zio.aws.ssm.model.ComplianceExecutionSummary.ReadOnly
    ] = ZIO.succeed(executionSummary)
    def getItems: ZIO[Any, Nothing, List[
      zio.aws.ssm.model.ComplianceItemEntry.ReadOnly
    ]] = ZIO.succeed(items)
    def getItemContentHash: ZIO[Any, AwsError, ComplianceItemContentHash] =
      AwsError.unwrapOptionField("itemContentHash", itemContentHash)
    def getUploadType
        : ZIO[Any, AwsError, zio.aws.ssm.model.ComplianceUploadType] =
      AwsError.unwrapOptionField("uploadType", uploadType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.PutComplianceItemsRequest
  ) extends zio.aws.ssm.model.PutComplianceItemsRequest.ReadOnly {
    override val resourceId: ComplianceResourceId =
      zio.aws.ssm.model.primitives.ComplianceResourceId(impl.resourceId())
    override val resourceType: ComplianceResourceType =
      zio.aws.ssm.model.primitives.ComplianceResourceType(impl.resourceType())
    override val complianceType: ComplianceTypeName =
      zio.aws.ssm.model.primitives.ComplianceTypeName(impl.complianceType())
    override val executionSummary
        : zio.aws.ssm.model.ComplianceExecutionSummary.ReadOnly =
      zio.aws.ssm.model.ComplianceExecutionSummary.wrap(impl.executionSummary())
    override val items: List[zio.aws.ssm.model.ComplianceItemEntry.ReadOnly] =
      impl
        .items()
        .asScala
        .map { item =>
          zio.aws.ssm.model.ComplianceItemEntry.wrap(item)
        }
        .toList
    override val itemContentHash: Option[ComplianceItemContentHash] = scala
      .Option(impl.itemContentHash())
      .map(value =>
        zio.aws.ssm.model.primitives.ComplianceItemContentHash(value)
      )
    override val uploadType: Option[zio.aws.ssm.model.ComplianceUploadType] =
      scala
        .Option(impl.uploadType())
        .map(value => zio.aws.ssm.model.ComplianceUploadType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.PutComplianceItemsRequest
  ): zio.aws.ssm.model.PutComplianceItemsRequest.ReadOnly = new Wrapper(impl)
}
