package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.ParameterValue
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResolvedTargets(
    parameterValues: Option[Iterable[ParameterValue]] = None,
    truncated: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ResolvedTargets = {
    import ResolvedTargets.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ResolvedTargets
      .builder()
      .optionallyWith(
        parameterValues.map(value =>
          value.map { item =>
            ParameterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.parameterValues)
      .optionallyWith(truncated.map(value => value: java.lang.Boolean))(
        _.truncated
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ResolvedTargets.ReadOnly =
    zio.aws.ssm.model.ResolvedTargets.wrap(buildAwsValue())
}
object ResolvedTargets {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ResolvedTargets
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ResolvedTargets =
      zio.aws.ssm.model.ResolvedTargets(
        parameterValues.map(value => value),
        truncated.map(value => value)
      )
    def parameterValues: Option[List[ParameterValue]]
    def truncated: Option[Boolean]
    def getParameterValues: ZIO[Any, AwsError, List[ParameterValue]] =
      AwsError.unwrapOptionField("parameterValues", parameterValues)
    def getTruncated: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("truncated", truncated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ResolvedTargets
  ) extends zio.aws.ssm.model.ResolvedTargets.ReadOnly {
    override val parameterValues: Option[List[ParameterValue]] = scala
      .Option(impl.parameterValues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.ParameterValue(item)
        }.toList
      )
    override val truncated: Option[Boolean] =
      scala.Option(impl.truncated()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ResolvedTargets
  ): zio.aws.ssm.model.ResolvedTargets.ReadOnly = new Wrapper(impl)
}
