package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{Reviewer, DateTime}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ReviewInformation(
    reviewedTime: Option[DateTime] = None,
    status: Option[zio.aws.ssm.model.ReviewStatus] = None,
    reviewer: Option[Reviewer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ReviewInformation = {
    import ReviewInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ReviewInformation
      .builder()
      .optionallyWith(
        reviewedTime.map(value => DateTime.unwrap(value): Instant)
      )(_.reviewedTime)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        reviewer.map(value => Reviewer.unwrap(value): java.lang.String)
      )(_.reviewer)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ReviewInformation.ReadOnly =
    zio.aws.ssm.model.ReviewInformation.wrap(buildAwsValue())
}
object ReviewInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ReviewInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ReviewInformation =
      zio.aws.ssm.model.ReviewInformation(
        reviewedTime.map(value => value),
        status.map(value => value),
        reviewer.map(value => value)
      )
    def reviewedTime: Option[DateTime]
    def status: Option[zio.aws.ssm.model.ReviewStatus]
    def reviewer: Option[Reviewer]
    def getReviewedTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("reviewedTime", reviewedTime)
    def getStatus: ZIO[Any, AwsError, zio.aws.ssm.model.ReviewStatus] =
      AwsError.unwrapOptionField("status", status)
    def getReviewer: ZIO[Any, AwsError, Reviewer] =
      AwsError.unwrapOptionField("reviewer", reviewer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ReviewInformation
  ) extends zio.aws.ssm.model.ReviewInformation.ReadOnly {
    override val reviewedTime: Option[DateTime] = scala
      .Option(impl.reviewedTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val status: Option[zio.aws.ssm.model.ReviewStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.ssm.model.ReviewStatus.wrap(value))
    override val reviewer: Option[Reviewer] = scala
      .Option(impl.reviewer())
      .map(value => zio.aws.ssm.model.primitives.Reviewer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ReviewInformation
  ): zio.aws.ssm.model.ReviewInformation.ReadOnly = new Wrapper(impl)
}
