package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  TargetMapValue,
  AutomationParameterValue,
  TargetMapKey,
  DocumentARN,
  DocumentVersion,
  AutomationParameterKey,
  IdempotencyToken,
  MaxConcurrency,
  MaxErrors
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StartAutomationExecutionRequest(
    documentName: DocumentARN,
    documentVersion: Option[DocumentVersion] = None,
    parameters: Option[
      Map[AutomationParameterKey, Iterable[AutomationParameterValue]]
    ] = None,
    clientToken: Option[IdempotencyToken] = None,
    mode: Option[zio.aws.ssm.model.ExecutionMode] = None,
    targetParameterName: Option[AutomationParameterKey] = None,
    targets: Option[Iterable[zio.aws.ssm.model.Target]] = None,
    targetMaps: Option[Iterable[Map[TargetMapKey, Iterable[TargetMapValue]]]] =
      None,
    maxConcurrency: Option[MaxConcurrency] = None,
    maxErrors: Option[MaxErrors] = None,
    targetLocations: Option[Iterable[zio.aws.ssm.model.TargetLocation]] = None,
    tags: Option[Iterable[zio.aws.ssm.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.StartAutomationExecutionRequest = {
    import StartAutomationExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.StartAutomationExecutionRequest
      .builder()
      .documentName(DocumentARN.unwrap(documentName): java.lang.String)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (AutomationParameterKey.unwrap(
                key
              ): java.lang.String) -> value.map { item =>
                AutomationParameterValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(
        clientToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(
        targetParameterName.map(value =>
          AutomationParameterKey.unwrap(value): java.lang.String
        )
      )(_.targetParameterName)
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(
        targetMaps.map(value =>
          value.map { item =>
            item
              .map({ case (key, value) =>
                (TargetMapKey.unwrap(key): java.lang.String) -> value.map {
                  item =>
                    TargetMapValue.unwrap(item): java.lang.String
                }.asJavaCollection
              })
              .asJava
          }.asJavaCollection
        )
      )(_.targetMaps)
      .optionallyWith(
        maxConcurrency.map(value =>
          MaxConcurrency.unwrap(value): java.lang.String
        )
      )(_.maxConcurrency)
      .optionallyWith(
        maxErrors.map(value => MaxErrors.unwrap(value): java.lang.String)
      )(_.maxErrors)
      .optionallyWith(
        targetLocations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetLocations)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.StartAutomationExecutionRequest.ReadOnly =
    zio.aws.ssm.model.StartAutomationExecutionRequest.wrap(buildAwsValue())
}
object StartAutomationExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.StartAutomationExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.StartAutomationExecutionRequest =
      zio.aws.ssm.model.StartAutomationExecutionRequest(
        documentName,
        documentVersion.map(value => value),
        parameters.map(value => value),
        clientToken.map(value => value),
        mode.map(value => value),
        targetParameterName.map(value => value),
        targets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        targetMaps.map(value => value),
        maxConcurrency.map(value => value),
        maxErrors.map(value => value),
        targetLocations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def documentName: DocumentARN
    def documentVersion: Option[DocumentVersion]
    def parameters
        : Option[Map[AutomationParameterKey, List[AutomationParameterValue]]]
    def clientToken: Option[IdempotencyToken]
    def mode: Option[zio.aws.ssm.model.ExecutionMode]
    def targetParameterName: Option[AutomationParameterKey]
    def targets: Option[List[zio.aws.ssm.model.Target.ReadOnly]]
    def targetMaps: Option[List[Map[TargetMapKey, List[TargetMapValue]]]]
    def maxConcurrency: Option[MaxConcurrency]
    def maxErrors: Option[MaxErrors]
    def targetLocations: Option[List[zio.aws.ssm.model.TargetLocation.ReadOnly]]
    def tags: Option[List[zio.aws.ssm.model.Tag.ReadOnly]]
    def getDocumentName: ZIO[Any, Nothing, DocumentARN] =
      ZIO.succeed(documentName)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getParameters: ZIO[Any, AwsError, Map[AutomationParameterKey, List[
      AutomationParameterValue
    ]]] = AwsError.unwrapOptionField("parameters", parameters)
    def getClientToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getMode: ZIO[Any, AwsError, zio.aws.ssm.model.ExecutionMode] =
      AwsError.unwrapOptionField("mode", mode)
    def getTargetParameterName: ZIO[Any, AwsError, AutomationParameterKey] =
      AwsError.unwrapOptionField("targetParameterName", targetParameterName)
    def getTargets
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Target.ReadOnly]] =
      AwsError.unwrapOptionField("targets", targets)
    def getTargetMaps
        : ZIO[Any, AwsError, List[Map[TargetMapKey, List[TargetMapValue]]]] =
      AwsError.unwrapOptionField("targetMaps", targetMaps)
    def getMaxConcurrency: ZIO[Any, AwsError, MaxConcurrency] =
      AwsError.unwrapOptionField("maxConcurrency", maxConcurrency)
    def getMaxErrors: ZIO[Any, AwsError, MaxErrors] =
      AwsError.unwrapOptionField("maxErrors", maxErrors)
    def getTargetLocations
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.TargetLocation.ReadOnly]] =
      AwsError.unwrapOptionField("targetLocations", targetLocations)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ssm.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.StartAutomationExecutionRequest
  ) extends zio.aws.ssm.model.StartAutomationExecutionRequest.ReadOnly {
    override val documentName: DocumentARN =
      zio.aws.ssm.model.primitives.DocumentARN(impl.documentName())
    override val documentVersion: Option[DocumentVersion] = scala
      .Option(impl.documentVersion())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val parameters
        : Option[Map[AutomationParameterKey, List[AutomationParameterValue]]] =
      scala
        .Option(impl.parameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.ssm.model.primitives
                .AutomationParameterKey(key) -> value.asScala.map { item =>
                zio.aws.ssm.model.primitives.AutomationParameterValue(item)
              }.toList
            })
            .toMap
        )
    override val clientToken: Option[IdempotencyToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.ssm.model.primitives.IdempotencyToken(value))
    override val mode: Option[zio.aws.ssm.model.ExecutionMode] = scala
      .Option(impl.mode())
      .map(value => zio.aws.ssm.model.ExecutionMode.wrap(value))
    override val targetParameterName: Option[AutomationParameterKey] = scala
      .Option(impl.targetParameterName())
      .map(value => zio.aws.ssm.model.primitives.AutomationParameterKey(value))
    override val targets: Option[List[zio.aws.ssm.model.Target.ReadOnly]] =
      scala
        .Option(impl.targets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Target.wrap(item)
          }.toList
        )
    override val targetMaps
        : Option[List[Map[TargetMapKey, List[TargetMapValue]]]] = scala
      .Option(impl.targetMaps())
      .map(value =>
        value.asScala.map { item =>
          item.asScala
            .map({ case (key, value) =>
              zio.aws.ssm.model.primitives
                .TargetMapKey(key) -> value.asScala.map { item =>
                zio.aws.ssm.model.primitives.TargetMapValue(item)
              }.toList
            })
            .toMap
        }.toList
      )
    override val maxConcurrency: Option[MaxConcurrency] = scala
      .Option(impl.maxConcurrency())
      .map(value => zio.aws.ssm.model.primitives.MaxConcurrency(value))
    override val maxErrors: Option[MaxErrors] = scala
      .Option(impl.maxErrors())
      .map(value => zio.aws.ssm.model.primitives.MaxErrors(value))
    override val targetLocations
        : Option[List[zio.aws.ssm.model.TargetLocation.ReadOnly]] = scala
      .Option(impl.targetLocations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.TargetLocation.wrap(item)
        }.toList
      )
    override val tags: Option[List[zio.aws.ssm.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.StartAutomationExecutionRequest
  ): zio.aws.ssm.model.StartAutomationExecutionRequest.ReadOnly = new Wrapper(
    impl
  )
}
