package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.AutomationExecutionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StopAutomationExecutionRequest(
    automationExecutionId: AutomationExecutionId,
    `type`: Option[zio.aws.ssm.model.StopType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.StopAutomationExecutionRequest = {
    import StopAutomationExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.StopAutomationExecutionRequest
      .builder()
      .automationExecutionId(
        AutomationExecutionId.unwrap(automationExecutionId): java.lang.String
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.StopAutomationExecutionRequest.ReadOnly =
    zio.aws.ssm.model.StopAutomationExecutionRequest.wrap(buildAwsValue())
}
object StopAutomationExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.StopAutomationExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.StopAutomationExecutionRequest =
      zio.aws.ssm.model.StopAutomationExecutionRequest(
        automationExecutionId,
        `type`.map(value => value)
      )
    def automationExecutionId: AutomationExecutionId
    def `type`: Option[zio.aws.ssm.model.StopType]
    def getAutomationExecutionId: ZIO[Any, Nothing, AutomationExecutionId] =
      ZIO.succeed(automationExecutionId)
    def getType: ZIO[Any, AwsError, zio.aws.ssm.model.StopType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.StopAutomationExecutionRequest
  ) extends zio.aws.ssm.model.StopAutomationExecutionRequest.ReadOnly {
    override val automationExecutionId: AutomationExecutionId =
      zio.aws.ssm.model.primitives
        .AutomationExecutionId(impl.automationExecutionId())
    override val `type`: Option[zio.aws.ssm.model.StopType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.ssm.model.StopType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.StopAutomationExecutionRequest
  ): zio.aws.ssm.model.StopAutomationExecutionRequest.ReadOnly = new Wrapper(
    impl
  )
}
