package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateDocumentDefaultVersionResponse(
    description: Option[zio.aws.ssm.model.DocumentDefaultVersionDescription] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.UpdateDocumentDefaultVersionResponse = {
    import UpdateDocumentDefaultVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.UpdateDocumentDefaultVersionResponse
      .builder()
      .optionallyWith(description.map(value => value.buildAwsValue()))(
        _.description
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.UpdateDocumentDefaultVersionResponse.ReadOnly =
    zio.aws.ssm.model.UpdateDocumentDefaultVersionResponse.wrap(buildAwsValue())
}
object UpdateDocumentDefaultVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.UpdateDocumentDefaultVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.UpdateDocumentDefaultVersionResponse =
      zio.aws.ssm.model.UpdateDocumentDefaultVersionResponse(
        description.map(value => value.asEditable)
      )
    def description
        : Option[zio.aws.ssm.model.DocumentDefaultVersionDescription.ReadOnly]
    def getDescription: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.DocumentDefaultVersionDescription.ReadOnly
    ] = AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.UpdateDocumentDefaultVersionResponse
  ) extends zio.aws.ssm.model.UpdateDocumentDefaultVersionResponse.ReadOnly {
    override val description
        : Option[zio.aws.ssm.model.DocumentDefaultVersionDescription.ReadOnly] =
      scala
        .Option(impl.description())
        .map(value =>
          zio.aws.ssm.model.DocumentDefaultVersionDescription.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.UpdateDocumentDefaultVersionResponse
  ): zio.aws.ssm.model.UpdateDocumentDefaultVersionResponse.ReadOnly =
    new Wrapper(impl)
}
