package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  DocumentDisplayName,
  DocumentName,
  DocumentVersion,
  DocumentContent,
  DocumentVersionName,
  TargetType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateDocumentRequest(
    content: DocumentContent,
    attachments: Option[Iterable[zio.aws.ssm.model.AttachmentsSource]] = None,
    name: DocumentName,
    displayName: Option[DocumentDisplayName] = None,
    versionName: Option[DocumentVersionName] = None,
    documentVersion: Option[DocumentVersion] = None,
    documentFormat: Option[zio.aws.ssm.model.DocumentFormat] = None,
    targetType: Option[TargetType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.UpdateDocumentRequest = {
    import UpdateDocumentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.UpdateDocumentRequest
      .builder()
      .content(DocumentContent.unwrap(content): java.lang.String)
      .optionallyWith(
        attachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachments)
      .name(DocumentName.unwrap(name): java.lang.String)
      .optionallyWith(
        displayName.map(value =>
          DocumentDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        versionName.map(value =>
          DocumentVersionName.unwrap(value): java.lang.String
        )
      )(_.versionName)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(documentFormat.map(value => value.unwrap))(
        _.documentFormat
      )
      .optionallyWith(
        targetType.map(value => TargetType.unwrap(value): java.lang.String)
      )(_.targetType)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.UpdateDocumentRequest.ReadOnly =
    zio.aws.ssm.model.UpdateDocumentRequest.wrap(buildAwsValue())
}
object UpdateDocumentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.UpdateDocumentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.UpdateDocumentRequest =
      zio.aws.ssm.model.UpdateDocumentRequest(
        content,
        attachments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name,
        displayName.map(value => value),
        versionName.map(value => value),
        documentVersion.map(value => value),
        documentFormat.map(value => value),
        targetType.map(value => value)
      )
    def content: DocumentContent
    def attachments: Option[List[zio.aws.ssm.model.AttachmentsSource.ReadOnly]]
    def name: DocumentName
    def displayName: Option[DocumentDisplayName]
    def versionName: Option[DocumentVersionName]
    def documentVersion: Option[DocumentVersion]
    def documentFormat: Option[zio.aws.ssm.model.DocumentFormat]
    def targetType: Option[TargetType]
    def getContent: ZIO[Any, Nothing, DocumentContent] = ZIO.succeed(content)
    def getAttachments: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.AttachmentsSource.ReadOnly
    ]] = AwsError.unwrapOptionField("attachments", attachments)
    def getName: ZIO[Any, Nothing, DocumentName] = ZIO.succeed(name)
    def getDisplayName: ZIO[Any, AwsError, DocumentDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getVersionName: ZIO[Any, AwsError, DocumentVersionName] =
      AwsError.unwrapOptionField("versionName", versionName)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getDocumentFormat
        : ZIO[Any, AwsError, zio.aws.ssm.model.DocumentFormat] =
      AwsError.unwrapOptionField("documentFormat", documentFormat)
    def getTargetType: ZIO[Any, AwsError, TargetType] =
      AwsError.unwrapOptionField("targetType", targetType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.UpdateDocumentRequest
  ) extends zio.aws.ssm.model.UpdateDocumentRequest.ReadOnly {
    override val content: DocumentContent =
      zio.aws.ssm.model.primitives.DocumentContent(impl.content())
    override val attachments
        : Option[List[zio.aws.ssm.model.AttachmentsSource.ReadOnly]] = scala
      .Option(impl.attachments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.AttachmentsSource.wrap(item)
        }.toList
      )
    override val name: DocumentName =
      zio.aws.ssm.model.primitives.DocumentName(impl.name())
    override val displayName: Option[DocumentDisplayName] = scala
      .Option(impl.displayName())
      .map(value => zio.aws.ssm.model.primitives.DocumentDisplayName(value))
    override val versionName: Option[DocumentVersionName] = scala
      .Option(impl.versionName())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersionName(value))
    override val documentVersion: Option[DocumentVersion] = scala
      .Option(impl.documentVersion())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val documentFormat: Option[zio.aws.ssm.model.DocumentFormat] =
      scala
        .Option(impl.documentFormat())
        .map(value => zio.aws.ssm.model.DocumentFormat.wrap(value))
    override val targetType: Option[TargetType] = scala
      .Option(impl.targetType())
      .map(value => zio.aws.ssm.model.primitives.TargetType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.UpdateDocumentRequest
  ): zio.aws.ssm.model.UpdateDocumentRequest.ReadOnly = new Wrapper(impl)
}
