package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{IamRole, ManagedInstanceId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateManagedInstanceRoleRequest(
    instanceId: ManagedInstanceId,
    iamRole: IamRole
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.UpdateManagedInstanceRoleRequest = {
    import UpdateManagedInstanceRoleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.UpdateManagedInstanceRoleRequest
      .builder()
      .instanceId(ManagedInstanceId.unwrap(instanceId): java.lang.String)
      .iamRole(IamRole.unwrap(iamRole): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.UpdateManagedInstanceRoleRequest.ReadOnly =
    zio.aws.ssm.model.UpdateManagedInstanceRoleRequest.wrap(buildAwsValue())
}
object UpdateManagedInstanceRoleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.UpdateManagedInstanceRoleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.UpdateManagedInstanceRoleRequest =
      zio.aws.ssm.model.UpdateManagedInstanceRoleRequest(instanceId, iamRole)
    def instanceId: ManagedInstanceId
    def iamRole: IamRole
    def getInstanceId: ZIO[Any, Nothing, ManagedInstanceId] =
      ZIO.succeed(instanceId)
    def getIamRole: ZIO[Any, Nothing, IamRole] = ZIO.succeed(iamRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.UpdateManagedInstanceRoleRequest
  ) extends zio.aws.ssm.model.UpdateManagedInstanceRoleRequest.ReadOnly {
    override val instanceId: ManagedInstanceId =
      zio.aws.ssm.model.primitives.ManagedInstanceId(impl.instanceId())
    override val iamRole: IamRole =
      zio.aws.ssm.model.primitives.IamRole(impl.iamRole())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.UpdateManagedInstanceRoleRequest
  ): zio.aws.ssm.model.UpdateManagedInstanceRoleRequest.ReadOnly = new Wrapper(
    impl
  )
}
