package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.OpsMetadataArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateOpsMetadataResponse(
    opsMetadataArn: Option[OpsMetadataArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.UpdateOpsMetadataResponse = {
    import UpdateOpsMetadataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.UpdateOpsMetadataResponse
      .builder()
      .optionallyWith(
        opsMetadataArn.map(value =>
          OpsMetadataArn.unwrap(value): java.lang.String
        )
      )(_.opsMetadataArn)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.UpdateOpsMetadataResponse.ReadOnly =
    zio.aws.ssm.model.UpdateOpsMetadataResponse.wrap(buildAwsValue())
}
object UpdateOpsMetadataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.UpdateOpsMetadataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.UpdateOpsMetadataResponse =
      zio.aws.ssm.model
        .UpdateOpsMetadataResponse(opsMetadataArn.map(value => value))
    def opsMetadataArn: Option[OpsMetadataArn]
    def getOpsMetadataArn: ZIO[Any, AwsError, OpsMetadataArn] =
      AwsError.unwrapOptionField("opsMetadataArn", opsMetadataArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.UpdateOpsMetadataResponse
  ) extends zio.aws.ssm.model.UpdateOpsMetadataResponse.ReadOnly {
    override val opsMetadataArn: Option[OpsMetadataArn] = scala
      .Option(impl.opsMetadataArn())
      .map(value => zio.aws.ssm.model.primitives.OpsMetadataArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.UpdateOpsMetadataResponse
  ): zio.aws.ssm.model.UpdateOpsMetadataResponse.ReadOnly = new Wrapper(impl)
}
