package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait AttachmentsSourceKey {
  def unwrap: software.amazon.awssdk.services.ssm.model.AttachmentsSourceKey
}
object AttachmentsSourceKey {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.AttachmentsSourceKey
  ): zio.aws.ssm.model.AttachmentsSourceKey = value match {
    case software.amazon.awssdk.services.ssm.model.AttachmentsSourceKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.AttachmentsSourceKey.SOURCE_URL =>
      val r = SourceUrl
      r
    case software.amazon.awssdk.services.ssm.model.AttachmentsSourceKey.S3_FILE_URL =>
      val r = S3FileUrl
      r
    case software.amazon.awssdk.services.ssm.model.AttachmentsSourceKey.ATTACHMENT_REFERENCE =>
      val r = AttachmentReference
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.AttachmentsSourceKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AttachmentsSourceKey =
      software.amazon.awssdk.services.ssm.model.AttachmentsSourceKey.UNKNOWN_TO_SDK_VERSION
  }
  case object SourceUrl extends zio.aws.ssm.model.AttachmentsSourceKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AttachmentsSourceKey =
      software.amazon.awssdk.services.ssm.model.AttachmentsSourceKey.SOURCE_URL
  }
  case object S3FileUrl extends zio.aws.ssm.model.AttachmentsSourceKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AttachmentsSourceKey =
      software.amazon.awssdk.services.ssm.model.AttachmentsSourceKey.S3_FILE_URL
  }
  case object AttachmentReference
      extends zio.aws.ssm.model.AttachmentsSourceKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AttachmentsSourceKey =
      software.amazon.awssdk.services.ssm.model.AttachmentsSourceKey.ATTACHMENT_REFERENCE
  }
}
