package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeMaintenanceWindowTargetsResponse(
    targets: Optional[Iterable[zio.aws.ssm.model.MaintenanceWindowTarget]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsResponse = {
    import DescribeMaintenanceWindowTargetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsResponse
      .builder()
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeMaintenanceWindowTargetsResponse.ReadOnly =
    zio.aws.ssm.model.DescribeMaintenanceWindowTargetsResponse
      .wrap(buildAwsValue())
}
object DescribeMaintenanceWindowTargetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeMaintenanceWindowTargetsResponse =
      zio.aws.ssm.model.DescribeMaintenanceWindowTargetsResponse(
        targets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def targets
        : Optional[List[zio.aws.ssm.model.MaintenanceWindowTarget.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getTargets: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.MaintenanceWindowTarget.ReadOnly
    ]] = AwsError.unwrapOptionField("targets", targets)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsResponse
  ) extends zio.aws.ssm.model.DescribeMaintenanceWindowTargetsResponse.ReadOnly {
    override val targets
        : Optional[List[zio.aws.ssm.model.MaintenanceWindowTarget.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.MaintenanceWindowTarget.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsResponse
  ): zio.aws.ssm.model.DescribeMaintenanceWindowTargetsResponse.ReadOnly =
    new Wrapper(impl)
}
