package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  DocumentKeyValuesFilterValue,
  DocumentKeyValuesFilterKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DocumentKeyValuesFilter(
    key: Optional[DocumentKeyValuesFilterKey] = Optional.Absent,
    values: Optional[Iterable[DocumentKeyValuesFilterValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DocumentKeyValuesFilter = {
    import DocumentKeyValuesFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DocumentKeyValuesFilter
      .builder()
      .optionallyWith(
        key.map(value =>
          DocumentKeyValuesFilterKey.unwrap(value): java.lang.String
        )
      )(_.key)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            DocumentKeyValuesFilterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DocumentKeyValuesFilter.ReadOnly =
    zio.aws.ssm.model.DocumentKeyValuesFilter.wrap(buildAwsValue())
}
object DocumentKeyValuesFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DocumentKeyValuesFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DocumentKeyValuesFilter =
      zio.aws.ssm.model.DocumentKeyValuesFilter(
        key.map(value => value),
        values.map(value => value)
      )
    def key: Optional[DocumentKeyValuesFilterKey]
    def values: Optional[List[DocumentKeyValuesFilterValue]]
    def getKey: ZIO[Any, AwsError, DocumentKeyValuesFilterKey] =
      AwsError.unwrapOptionField("key", key)
    def getValues: ZIO[Any, AwsError, List[DocumentKeyValuesFilterValue]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DocumentKeyValuesFilter
  ) extends zio.aws.ssm.model.DocumentKeyValuesFilter.ReadOnly {
    override val key: Optional[DocumentKeyValuesFilterKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.key())
        .map(value =>
          zio.aws.ssm.model.primitives.DocumentKeyValuesFilterKey(value)
        )
    override val values: Optional[List[DocumentKeyValuesFilterValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.values())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.primitives.DocumentKeyValuesFilterValue(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DocumentKeyValuesFilter
  ): zio.aws.ssm.model.DocumentKeyValuesFilter.ReadOnly = new Wrapper(impl)
}
