package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  MaxResults,
  NextToken,
  ResourceDataSyncName
}
import scala.jdk.CollectionConverters.*
final case class GetOpsSummaryRequest(
    syncName: Optional[ResourceDataSyncName] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ssm.model.OpsFilter]] = Optional.Absent,
    aggregators: Optional[Iterable[zio.aws.ssm.model.OpsAggregator]] =
      Optional.Absent,
    resultAttributes: Optional[Iterable[zio.aws.ssm.model.OpsResultAttribute]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetOpsSummaryRequest = {
    import GetOpsSummaryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetOpsSummaryRequest
      .builder()
      .optionallyWith(
        syncName.map(value =>
          ResourceDataSyncName.unwrap(value): java.lang.String
        )
      )(_.syncName)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        aggregators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.aggregators)
      .optionallyWith(
        resultAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resultAttributes)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetOpsSummaryRequest.ReadOnly =
    zio.aws.ssm.model.GetOpsSummaryRequest.wrap(buildAwsValue())
}
object GetOpsSummaryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetOpsSummaryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetOpsSummaryRequest =
      zio.aws.ssm.model.GetOpsSummaryRequest(
        syncName.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        aggregators.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resultAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def syncName: Optional[ResourceDataSyncName]
    def filters: Optional[List[zio.aws.ssm.model.OpsFilter.ReadOnly]]
    def aggregators: Optional[List[zio.aws.ssm.model.OpsAggregator.ReadOnly]]
    def resultAttributes
        : Optional[List[zio.aws.ssm.model.OpsResultAttribute.ReadOnly]]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getSyncName: ZIO[Any, AwsError, ResourceDataSyncName] =
      AwsError.unwrapOptionField("syncName", syncName)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.OpsFilter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getAggregators
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.OpsAggregator.ReadOnly]] =
      AwsError.unwrapOptionField("aggregators", aggregators)
    def getResultAttributes: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.OpsResultAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("resultAttributes", resultAttributes)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetOpsSummaryRequest
  ) extends zio.aws.ssm.model.GetOpsSummaryRequest.ReadOnly {
    override val syncName: Optional[ResourceDataSyncName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.syncName())
        .map(value => zio.aws.ssm.model.primitives.ResourceDataSyncName(value))
    override val filters: Optional[List[zio.aws.ssm.model.OpsFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.OpsFilter.wrap(item)
          }.toList
        )
    override val aggregators
        : Optional[List[zio.aws.ssm.model.OpsAggregator.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aggregators())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.OpsAggregator.wrap(item)
          }.toList
        )
    override val resultAttributes
        : Optional[List[zio.aws.ssm.model.OpsResultAttribute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resultAttributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.OpsResultAttribute.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetOpsSummaryRequest
  ): zio.aws.ssm.model.GetOpsSummaryRequest.ReadOnly = new Wrapper(impl)
}
