package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  NextToken,
  GetParametersByPathMaxResults,
  PSParameterName
}
import scala.jdk.CollectionConverters.*
final case class GetParametersByPathRequest(
    path: PSParameterName,
    recursive: Optional[Boolean] = Optional.Absent,
    parameterFilters: Optional[
      Iterable[zio.aws.ssm.model.ParameterStringFilter]
    ] = Optional.Absent,
    withDecryption: Optional[Boolean] = Optional.Absent,
    maxResults: Optional[GetParametersByPathMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest = {
    import GetParametersByPathRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest
      .builder()
      .path(PSParameterName.unwrap(path): java.lang.String)
      .optionallyWith(recursive.map(value => value: java.lang.Boolean))(
        _.recursive
      )
      .optionallyWith(
        parameterFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameterFilters)
      .optionallyWith(withDecryption.map(value => value: java.lang.Boolean))(
        _.withDecryption
      )
      .optionallyWith(
        maxResults.map(value =>
          GetParametersByPathMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetParametersByPathRequest.ReadOnly =
    zio.aws.ssm.model.GetParametersByPathRequest.wrap(buildAwsValue())
}
object GetParametersByPathRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetParametersByPathRequest =
      zio.aws.ssm.model.GetParametersByPathRequest(
        path,
        recursive.map(value => value),
        parameterFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        withDecryption.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def path: PSParameterName
    def recursive: Optional[Boolean]
    def parameterFilters
        : Optional[List[zio.aws.ssm.model.ParameterStringFilter.ReadOnly]]
    def withDecryption: Optional[Boolean]
    def maxResults: Optional[GetParametersByPathMaxResults]
    def nextToken: Optional[NextToken]
    def getPath: ZIO[Any, Nothing, PSParameterName] = ZIO.succeed(path)
    def getRecursive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("recursive", recursive)
    def getParameterFilters: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.ParameterStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameterFilters", parameterFilters)
    def getWithDecryption: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("withDecryption", withDecryption)
    def getMaxResults: ZIO[Any, AwsError, GetParametersByPathMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest
  ) extends zio.aws.ssm.model.GetParametersByPathRequest.ReadOnly {
    override val path: PSParameterName =
      zio.aws.ssm.model.primitives.PSParameterName(impl.path())
    override val recursive: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.recursive())
      .map(value => value: Boolean)
    override val parameterFilters
        : Optional[List[zio.aws.ssm.model.ParameterStringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameterFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.ParameterStringFilter.wrap(item)
          }.toList
        )
    override val withDecryption: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.withDecryption())
      .map(value => value: Boolean)
    override val maxResults: Optional[GetParametersByPathMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ssm.model.primitives.GetParametersByPathMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest
  ): zio.aws.ssm.model.GetParametersByPathRequest.ReadOnly = new Wrapper(impl)
}
