package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.ResourceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(
    resourceType: zio.aws.ssm.model.ResourceTypeForTagging,
    resourceId: ResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListTagsForResourceRequest
      .builder()
      .resourceType(resourceType.unwrap)
      .resourceId(ResourceId.unwrap(resourceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.ssm.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListTagsForResourceRequest =
      zio.aws.ssm.model.ListTagsForResourceRequest(resourceType, resourceId)
    def resourceType: zio.aws.ssm.model.ResourceTypeForTagging
    def resourceId: ResourceId
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.ssm.model.ResourceTypeForTagging] =
      ZIO.succeed(resourceType)
    def getResourceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(resourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListTagsForResourceRequest
  ) extends zio.aws.ssm.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceType: zio.aws.ssm.model.ResourceTypeForTagging =
      zio.aws.ssm.model.ResourceTypeForTagging.wrap(impl.resourceType())
    override val resourceId: ResourceId =
      zio.aws.ssm.model.primitives.ResourceId(impl.resourceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListTagsForResourceRequest
  ): zio.aws.ssm.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(impl)
}
