package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  MaintenanceWindowLambdaPayload,
  MaintenanceWindowLambdaQualifier,
  MaintenanceWindowLambdaClientContext
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MaintenanceWindowLambdaParameters(
    clientContext: Optional[MaintenanceWindowLambdaClientContext] =
      Optional.Absent,
    qualifier: Optional[MaintenanceWindowLambdaQualifier] = Optional.Absent,
    payload: Optional[MaintenanceWindowLambdaPayload] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.MaintenanceWindowLambdaParameters = {
    import MaintenanceWindowLambdaParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.MaintenanceWindowLambdaParameters
      .builder()
      .optionallyWith(
        clientContext.map(value =>
          MaintenanceWindowLambdaClientContext.unwrap(value): java.lang.String
        )
      )(_.clientContext)
      .optionallyWith(
        qualifier.map(value =>
          MaintenanceWindowLambdaQualifier.unwrap(value): java.lang.String
        )
      )(_.qualifier)
      .optionallyWith(
        payload.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.payload)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.MaintenanceWindowLambdaParameters.ReadOnly =
    zio.aws.ssm.model.MaintenanceWindowLambdaParameters.wrap(buildAwsValue())
}
object MaintenanceWindowLambdaParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.MaintenanceWindowLambdaParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.MaintenanceWindowLambdaParameters =
      zio.aws.ssm.model.MaintenanceWindowLambdaParameters(
        clientContext.map(value => value),
        qualifier.map(value => value),
        payload.map(value => value)
      )
    def clientContext: Optional[MaintenanceWindowLambdaClientContext]
    def qualifier: Optional[MaintenanceWindowLambdaQualifier]
    def payload: Optional[MaintenanceWindowLambdaPayload]
    def getClientContext
        : ZIO[Any, AwsError, MaintenanceWindowLambdaClientContext] =
      AwsError.unwrapOptionField("clientContext", clientContext)
    def getQualifier: ZIO[Any, AwsError, MaintenanceWindowLambdaQualifier] =
      AwsError.unwrapOptionField("qualifier", qualifier)
    def getPayload: ZIO[Any, AwsError, MaintenanceWindowLambdaPayload] =
      AwsError.unwrapOptionField("payload", payload)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.MaintenanceWindowLambdaParameters
  ) extends zio.aws.ssm.model.MaintenanceWindowLambdaParameters.ReadOnly {
    override val clientContext: Optional[MaintenanceWindowLambdaClientContext] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientContext())
        .map(value =>
          zio.aws.ssm.model.primitives
            .MaintenanceWindowLambdaClientContext(value)
        )
    override val qualifier: Optional[MaintenanceWindowLambdaQualifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.qualifier())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowLambdaQualifier(value)
        )
    override val payload: Optional[MaintenanceWindowLambdaPayload] =
      zio.aws.core.internal
        .optionalFromNullable(impl.payload())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowLambdaPayload(
            zio.Chunk.fromArray(value.asByteArrayUnsafe())
          )
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.MaintenanceWindowLambdaParameters
  ): zio.aws.ssm.model.MaintenanceWindowLambdaParameters.ReadOnly = new Wrapper(
    impl
  )
}
