package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.ComplianceSummaryCount
import scala.jdk.CollectionConverters.*
final case class NonCompliantSummary(
    nonCompliantCount: Optional[ComplianceSummaryCount] = Optional.Absent,
    severitySummary: Optional[zio.aws.ssm.model.SeveritySummary] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.NonCompliantSummary = {
    import NonCompliantSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.NonCompliantSummary
      .builder()
      .optionallyWith(
        nonCompliantCount.map(value =>
          ComplianceSummaryCount.unwrap(value): Integer
        )
      )(_.nonCompliantCount)
      .optionallyWith(severitySummary.map(value => value.buildAwsValue()))(
        _.severitySummary
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.NonCompliantSummary.ReadOnly =
    zio.aws.ssm.model.NonCompliantSummary.wrap(buildAwsValue())
}
object NonCompliantSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.NonCompliantSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.NonCompliantSummary =
      zio.aws.ssm.model.NonCompliantSummary(
        nonCompliantCount.map(value => value),
        severitySummary.map(value => value.asEditable)
      )
    def nonCompliantCount: Optional[ComplianceSummaryCount]
    def severitySummary: Optional[zio.aws.ssm.model.SeveritySummary.ReadOnly]
    def getNonCompliantCount: ZIO[Any, AwsError, ComplianceSummaryCount] =
      AwsError.unwrapOptionField("nonCompliantCount", nonCompliantCount)
    def getSeveritySummary
        : ZIO[Any, AwsError, zio.aws.ssm.model.SeveritySummary.ReadOnly] =
      AwsError.unwrapOptionField("severitySummary", severitySummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.NonCompliantSummary
  ) extends zio.aws.ssm.model.NonCompliantSummary.ReadOnly {
    override val nonCompliantCount: Optional[ComplianceSummaryCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nonCompliantCount())
        .map(value =>
          zio.aws.ssm.model.primitives.ComplianceSummaryCount(value)
        )
    override val severitySummary
        : Optional[zio.aws.ssm.model.SeveritySummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severitySummary())
        .map(value => zio.aws.ssm.model.SeveritySummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.NonCompliantSummary
  ): zio.aws.ssm.model.NonCompliantSummary.ReadOnly = new Wrapper(impl)
}
