package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait OpsItemDataType {
  def unwrap: software.amazon.awssdk.services.ssm.model.OpsItemDataType
}
object OpsItemDataType {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.OpsItemDataType
  ): zio.aws.ssm.model.OpsItemDataType = value match {
    case software.amazon.awssdk.services.ssm.model.OpsItemDataType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemDataType.SEARCHABLE_STRING =>
      val r = SearchableString
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemDataType.STRING =>
      val r = String
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.OpsItemDataType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemDataType =
      software.amazon.awssdk.services.ssm.model.OpsItemDataType.UNKNOWN_TO_SDK_VERSION
  }
  case object SearchableString extends zio.aws.ssm.model.OpsItemDataType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemDataType =
      software.amazon.awssdk.services.ssm.model.OpsItemDataType.SEARCHABLE_STRING
  }
  case object String extends zio.aws.ssm.model.OpsItemDataType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemDataType =
      software.amazon.awssdk.services.ssm.model.OpsItemDataType.STRING
  }
}
