package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait PatchComplianceDataState {
  def unwrap: software.amazon.awssdk.services.ssm.model.PatchComplianceDataState
}
object PatchComplianceDataState {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.PatchComplianceDataState
  ): zio.aws.ssm.model.PatchComplianceDataState = value match {
    case software.amazon.awssdk.services.ssm.model.PatchComplianceDataState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.PatchComplianceDataState.INSTALLED =>
      val r = INSTALLED
      r
    case software.amazon.awssdk.services.ssm.model.PatchComplianceDataState.INSTALLED_OTHER =>
      val r = INSTALLED_OTHER
      r
    case software.amazon.awssdk.services.ssm.model.PatchComplianceDataState.INSTALLED_PENDING_REBOOT =>
      val r = INSTALLED_PENDING_REBOOT
      r
    case software.amazon.awssdk.services.ssm.model.PatchComplianceDataState.INSTALLED_REJECTED =>
      val r = INSTALLED_REJECTED
      r
    case software.amazon.awssdk.services.ssm.model.PatchComplianceDataState.MISSING =>
      val r = MISSING
      r
    case software.amazon.awssdk.services.ssm.model.PatchComplianceDataState.NOT_APPLICABLE =>
      val r = NOT_APPLICABLE
      r
    case software.amazon.awssdk.services.ssm.model.PatchComplianceDataState.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.PatchComplianceDataState {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchComplianceDataState =
      software.amazon.awssdk.services.ssm.model.PatchComplianceDataState.UNKNOWN_TO_SDK_VERSION
  }
  case object INSTALLED extends zio.aws.ssm.model.PatchComplianceDataState {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchComplianceDataState =
      software.amazon.awssdk.services.ssm.model.PatchComplianceDataState.INSTALLED
  }
  case object INSTALLED_OTHER
      extends zio.aws.ssm.model.PatchComplianceDataState {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchComplianceDataState =
      software.amazon.awssdk.services.ssm.model.PatchComplianceDataState.INSTALLED_OTHER
  }
  case object INSTALLED_PENDING_REBOOT
      extends zio.aws.ssm.model.PatchComplianceDataState {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchComplianceDataState =
      software.amazon.awssdk.services.ssm.model.PatchComplianceDataState.INSTALLED_PENDING_REBOOT
  }
  case object INSTALLED_REJECTED
      extends zio.aws.ssm.model.PatchComplianceDataState {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchComplianceDataState =
      software.amazon.awssdk.services.ssm.model.PatchComplianceDataState.INSTALLED_REJECTED
  }
  case object MISSING extends zio.aws.ssm.model.PatchComplianceDataState {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchComplianceDataState =
      software.amazon.awssdk.services.ssm.model.PatchComplianceDataState.MISSING
  }
  case object NOT_APPLICABLE
      extends zio.aws.ssm.model.PatchComplianceDataState {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchComplianceDataState =
      software.amazon.awssdk.services.ssm.model.PatchComplianceDataState.NOT_APPLICABLE
  }
  case object FAILED extends zio.aws.ssm.model.PatchComplianceDataState {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchComplianceDataState =
      software.amazon.awssdk.services.ssm.model.PatchComplianceDataState.FAILED
  }
}
