package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.SessionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ResumeSessionRequest(sessionId: SessionId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ResumeSessionRequest = {
    import ResumeSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ResumeSessionRequest
      .builder()
      .sessionId(SessionId.unwrap(sessionId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ResumeSessionRequest.ReadOnly =
    zio.aws.ssm.model.ResumeSessionRequest.wrap(buildAwsValue())
}
object ResumeSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ResumeSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ResumeSessionRequest =
      zio.aws.ssm.model.ResumeSessionRequest(sessionId)
    def sessionId: SessionId
    def getSessionId: ZIO[Any, Nothing, SessionId] = ZIO.succeed(sessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ResumeSessionRequest
  ) extends zio.aws.ssm.model.ResumeSessionRequest.ReadOnly {
    override val sessionId: SessionId =
      zio.aws.ssm.model.primitives.SessionId(impl.sessionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ResumeSessionRequest
  ): zio.aws.ssm.model.ResumeSessionRequest.ReadOnly = new Wrapper(impl)
}
