package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait SessionStatus {
  def unwrap: software.amazon.awssdk.services.ssm.model.SessionStatus
}
object SessionStatus {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.SessionStatus
  ): zio.aws.ssm.model.SessionStatus = value match {
    case software.amazon.awssdk.services.ssm.model.SessionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.SessionStatus.CONNECTED =>
      val r = Connected
      r
    case software.amazon.awssdk.services.ssm.model.SessionStatus.CONNECTING =>
      val r = Connecting
      r
    case software.amazon.awssdk.services.ssm.model.SessionStatus.DISCONNECTED =>
      val r = Disconnected
      r
    case software.amazon.awssdk.services.ssm.model.SessionStatus.TERMINATED =>
      val r = Terminated
      r
    case software.amazon.awssdk.services.ssm.model.SessionStatus.TERMINATING =>
      val r = Terminating
      r
    case software.amazon.awssdk.services.ssm.model.SessionStatus.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.SessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.SessionStatus =
      software.amazon.awssdk.services.ssm.model.SessionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Connected extends zio.aws.ssm.model.SessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.SessionStatus =
      software.amazon.awssdk.services.ssm.model.SessionStatus.CONNECTED
  }
  case object Connecting extends zio.aws.ssm.model.SessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.SessionStatus =
      software.amazon.awssdk.services.ssm.model.SessionStatus.CONNECTING
  }
  case object Disconnected extends zio.aws.ssm.model.SessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.SessionStatus =
      software.amazon.awssdk.services.ssm.model.SessionStatus.DISCONNECTED
  }
  case object Terminated extends zio.aws.ssm.model.SessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.SessionStatus =
      software.amazon.awssdk.services.ssm.model.SessionStatus.TERMINATED
  }
  case object Terminating extends zio.aws.ssm.model.SessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.SessionStatus =
      software.amazon.awssdk.services.ssm.model.SessionStatus.TERMINATING
  }
  case object Failed extends zio.aws.ssm.model.SessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.SessionStatus =
      software.amazon.awssdk.services.ssm.model.SessionStatus.FAILED
  }
}
