package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.ComplianceSummaryCount
import scala.jdk.CollectionConverters.*
final case class SeveritySummary(
    criticalCount: Optional[ComplianceSummaryCount] = Optional.Absent,
    highCount: Optional[ComplianceSummaryCount] = Optional.Absent,
    mediumCount: Optional[ComplianceSummaryCount] = Optional.Absent,
    lowCount: Optional[ComplianceSummaryCount] = Optional.Absent,
    informationalCount: Optional[ComplianceSummaryCount] = Optional.Absent,
    unspecifiedCount: Optional[ComplianceSummaryCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.SeveritySummary = {
    import SeveritySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.SeveritySummary
      .builder()
      .optionallyWith(
        criticalCount.map(value =>
          ComplianceSummaryCount.unwrap(value): Integer
        )
      )(_.criticalCount)
      .optionallyWith(
        highCount.map(value => ComplianceSummaryCount.unwrap(value): Integer)
      )(_.highCount)
      .optionallyWith(
        mediumCount.map(value => ComplianceSummaryCount.unwrap(value): Integer)
      )(_.mediumCount)
      .optionallyWith(
        lowCount.map(value => ComplianceSummaryCount.unwrap(value): Integer)
      )(_.lowCount)
      .optionallyWith(
        informationalCount.map(value =>
          ComplianceSummaryCount.unwrap(value): Integer
        )
      )(_.informationalCount)
      .optionallyWith(
        unspecifiedCount.map(value =>
          ComplianceSummaryCount.unwrap(value): Integer
        )
      )(_.unspecifiedCount)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.SeveritySummary.ReadOnly =
    zio.aws.ssm.model.SeveritySummary.wrap(buildAwsValue())
}
object SeveritySummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.SeveritySummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.SeveritySummary =
      zio.aws.ssm.model.SeveritySummary(
        criticalCount.map(value => value),
        highCount.map(value => value),
        mediumCount.map(value => value),
        lowCount.map(value => value),
        informationalCount.map(value => value),
        unspecifiedCount.map(value => value)
      )
    def criticalCount: Optional[ComplianceSummaryCount]
    def highCount: Optional[ComplianceSummaryCount]
    def mediumCount: Optional[ComplianceSummaryCount]
    def lowCount: Optional[ComplianceSummaryCount]
    def informationalCount: Optional[ComplianceSummaryCount]
    def unspecifiedCount: Optional[ComplianceSummaryCount]
    def getCriticalCount: ZIO[Any, AwsError, ComplianceSummaryCount] =
      AwsError.unwrapOptionField("criticalCount", criticalCount)
    def getHighCount: ZIO[Any, AwsError, ComplianceSummaryCount] =
      AwsError.unwrapOptionField("highCount", highCount)
    def getMediumCount: ZIO[Any, AwsError, ComplianceSummaryCount] =
      AwsError.unwrapOptionField("mediumCount", mediumCount)
    def getLowCount: ZIO[Any, AwsError, ComplianceSummaryCount] =
      AwsError.unwrapOptionField("lowCount", lowCount)
    def getInformationalCount: ZIO[Any, AwsError, ComplianceSummaryCount] =
      AwsError.unwrapOptionField("informationalCount", informationalCount)
    def getUnspecifiedCount: ZIO[Any, AwsError, ComplianceSummaryCount] =
      AwsError.unwrapOptionField("unspecifiedCount", unspecifiedCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.SeveritySummary
  ) extends zio.aws.ssm.model.SeveritySummary.ReadOnly {
    override val criticalCount: Optional[ComplianceSummaryCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.criticalCount())
        .map(value =>
          zio.aws.ssm.model.primitives.ComplianceSummaryCount(value)
        )
    override val highCount: Optional[ComplianceSummaryCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.highCount())
        .map(value =>
          zio.aws.ssm.model.primitives.ComplianceSummaryCount(value)
        )
    override val mediumCount: Optional[ComplianceSummaryCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mediumCount())
        .map(value =>
          zio.aws.ssm.model.primitives.ComplianceSummaryCount(value)
        )
    override val lowCount: Optional[ComplianceSummaryCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lowCount())
        .map(value =>
          zio.aws.ssm.model.primitives.ComplianceSummaryCount(value)
        )
    override val informationalCount: Optional[ComplianceSummaryCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.informationalCount())
        .map(value =>
          zio.aws.ssm.model.primitives.ComplianceSummaryCount(value)
        )
    override val unspecifiedCount: Optional[ComplianceSummaryCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unspecifiedCount())
        .map(value =>
          zio.aws.ssm.model.primitives.ComplianceSummaryCount(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.SeveritySummary
  ): zio.aws.ssm.model.SeveritySummary.ReadOnly = new Wrapper(impl)
}
