package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.PatchId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BaselineOverride(
    operatingSystem: Optional[zio.aws.ssm.model.OperatingSystem] =
      Optional.Absent,
    globalFilters: Optional[zio.aws.ssm.model.PatchFilterGroup] =
      Optional.Absent,
    approvalRules: Optional[zio.aws.ssm.model.PatchRuleGroup] = Optional.Absent,
    approvedPatches: Optional[Iterable[PatchId]] = Optional.Absent,
    approvedPatchesComplianceLevel: Optional[
      zio.aws.ssm.model.PatchComplianceLevel
    ] = Optional.Absent,
    rejectedPatches: Optional[Iterable[PatchId]] = Optional.Absent,
    rejectedPatchesAction: Optional[zio.aws.ssm.model.PatchAction] =
      Optional.Absent,
    approvedPatchesEnableNonSecurity: Optional[Boolean] = Optional.Absent,
    sources: Optional[Iterable[zio.aws.ssm.model.PatchSource]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.BaselineOverride = {
    import BaselineOverride.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.BaselineOverride
      .builder()
      .optionallyWith(operatingSystem.map(value => value.unwrap))(
        _.operatingSystem
      )
      .optionallyWith(globalFilters.map(value => value.buildAwsValue()))(
        _.globalFilters
      )
      .optionallyWith(approvalRules.map(value => value.buildAwsValue()))(
        _.approvalRules
      )
      .optionallyWith(
        approvedPatches.map(value =>
          value.map { item =>
            PatchId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.approvedPatches)
      .optionallyWith(
        approvedPatchesComplianceLevel.map(value => value.unwrap)
      )(_.approvedPatchesComplianceLevel)
      .optionallyWith(
        rejectedPatches.map(value =>
          value.map { item =>
            PatchId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.rejectedPatches)
      .optionallyWith(rejectedPatchesAction.map(value => value.unwrap))(
        _.rejectedPatchesAction
      )
      .optionallyWith(
        approvedPatchesEnableNonSecurity.map(value => value: java.lang.Boolean)
      )(_.approvedPatchesEnableNonSecurity)
      .optionallyWith(
        sources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sources)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.BaselineOverride.ReadOnly =
    zio.aws.ssm.model.BaselineOverride.wrap(buildAwsValue())
}
object BaselineOverride {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.BaselineOverride
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.BaselineOverride =
      zio.aws.ssm.model.BaselineOverride(
        operatingSystem.map(value => value),
        globalFilters.map(value => value.asEditable),
        approvalRules.map(value => value.asEditable),
        approvedPatches.map(value => value),
        approvedPatchesComplianceLevel.map(value => value),
        rejectedPatches.map(value => value),
        rejectedPatchesAction.map(value => value),
        approvedPatchesEnableNonSecurity.map(value => value),
        sources.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def operatingSystem: Optional[zio.aws.ssm.model.OperatingSystem]
    def globalFilters: Optional[zio.aws.ssm.model.PatchFilterGroup.ReadOnly]
    def approvalRules: Optional[zio.aws.ssm.model.PatchRuleGroup.ReadOnly]
    def approvedPatches: Optional[List[PatchId]]
    def approvedPatchesComplianceLevel
        : Optional[zio.aws.ssm.model.PatchComplianceLevel]
    def rejectedPatches: Optional[List[PatchId]]
    def rejectedPatchesAction: Optional[zio.aws.ssm.model.PatchAction]
    def approvedPatchesEnableNonSecurity: Optional[Boolean]
    def sources: Optional[List[zio.aws.ssm.model.PatchSource.ReadOnly]]
    def getOperatingSystem
        : ZIO[Any, AwsError, zio.aws.ssm.model.OperatingSystem] =
      AwsError.unwrapOptionField("operatingSystem", operatingSystem)
    def getGlobalFilters
        : ZIO[Any, AwsError, zio.aws.ssm.model.PatchFilterGroup.ReadOnly] =
      AwsError.unwrapOptionField("globalFilters", globalFilters)
    def getApprovalRules
        : ZIO[Any, AwsError, zio.aws.ssm.model.PatchRuleGroup.ReadOnly] =
      AwsError.unwrapOptionField("approvalRules", approvalRules)
    def getApprovedPatches: ZIO[Any, AwsError, List[PatchId]] =
      AwsError.unwrapOptionField("approvedPatches", approvedPatches)
    def getApprovedPatchesComplianceLevel
        : ZIO[Any, AwsError, zio.aws.ssm.model.PatchComplianceLevel] =
      AwsError.unwrapOptionField(
        "approvedPatchesComplianceLevel",
        approvedPatchesComplianceLevel
      )
    def getRejectedPatches: ZIO[Any, AwsError, List[PatchId]] =
      AwsError.unwrapOptionField("rejectedPatches", rejectedPatches)
    def getRejectedPatchesAction
        : ZIO[Any, AwsError, zio.aws.ssm.model.PatchAction] =
      AwsError.unwrapOptionField("rejectedPatchesAction", rejectedPatchesAction)
    def getApprovedPatchesEnableNonSecurity: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "approvedPatchesEnableNonSecurity",
        approvedPatchesEnableNonSecurity
      )
    def getSources
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.PatchSource.ReadOnly]] =
      AwsError.unwrapOptionField("sources", sources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.BaselineOverride
  ) extends zio.aws.ssm.model.BaselineOverride.ReadOnly {
    override val operatingSystem: Optional[zio.aws.ssm.model.OperatingSystem] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operatingSystem())
        .map(value => zio.aws.ssm.model.OperatingSystem.wrap(value))
    override val globalFilters
        : Optional[zio.aws.ssm.model.PatchFilterGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalFilters())
        .map(value => zio.aws.ssm.model.PatchFilterGroup.wrap(value))
    override val approvalRules
        : Optional[zio.aws.ssm.model.PatchRuleGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approvalRules())
        .map(value => zio.aws.ssm.model.PatchRuleGroup.wrap(value))
    override val approvedPatches: Optional[List[PatchId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approvedPatches())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.primitives.PatchId(item)
          }.toList
        )
    override val approvedPatchesComplianceLevel
        : Optional[zio.aws.ssm.model.PatchComplianceLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approvedPatchesComplianceLevel())
        .map(value => zio.aws.ssm.model.PatchComplianceLevel.wrap(value))
    override val rejectedPatches: Optional[List[PatchId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rejectedPatches())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.primitives.PatchId(item)
          }.toList
        )
    override val rejectedPatchesAction
        : Optional[zio.aws.ssm.model.PatchAction] = zio.aws.core.internal
      .optionalFromNullable(impl.rejectedPatchesAction())
      .map(value => zio.aws.ssm.model.PatchAction.wrap(value))
    override val approvedPatchesEnableNonSecurity: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approvedPatchesEnableNonSecurity())
        .map(value => value: Boolean)
    override val sources
        : Optional[List[zio.aws.ssm.model.PatchSource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.PatchSource.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.BaselineOverride
  ): zio.aws.ssm.model.BaselineOverride.ReadOnly = new Wrapper(impl)
}
