package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait CommandPluginStatus {
  def unwrap: software.amazon.awssdk.services.ssm.model.CommandPluginStatus
}
object CommandPluginStatus {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.CommandPluginStatus
  ): zio.aws.ssm.model.CommandPluginStatus = value match {
    case software.amazon.awssdk.services.ssm.model.CommandPluginStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.CommandPluginStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.ssm.model.CommandPluginStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.ssm.model.CommandPluginStatus.SUCCESS =>
      val r = Success
      r
    case software.amazon.awssdk.services.ssm.model.CommandPluginStatus.TIMED_OUT =>
      val r = TimedOut
      r
    case software.amazon.awssdk.services.ssm.model.CommandPluginStatus.CANCELLED =>
      val r = Cancelled
      r
    case software.amazon.awssdk.services.ssm.model.CommandPluginStatus.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.CommandPluginStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.CommandPluginStatus =
      software.amazon.awssdk.services.ssm.model.CommandPluginStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Pending extends zio.aws.ssm.model.CommandPluginStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.CommandPluginStatus =
      software.amazon.awssdk.services.ssm.model.CommandPluginStatus.PENDING
  }
  case object InProgress extends zio.aws.ssm.model.CommandPluginStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.CommandPluginStatus =
      software.amazon.awssdk.services.ssm.model.CommandPluginStatus.IN_PROGRESS
  }
  case object Success extends zio.aws.ssm.model.CommandPluginStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.CommandPluginStatus =
      software.amazon.awssdk.services.ssm.model.CommandPluginStatus.SUCCESS
  }
  case object TimedOut extends zio.aws.ssm.model.CommandPluginStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.CommandPluginStatus =
      software.amazon.awssdk.services.ssm.model.CommandPluginStatus.TIMED_OUT
  }
  case object Cancelled extends zio.aws.ssm.model.CommandPluginStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.CommandPluginStatus =
      software.amazon.awssdk.services.ssm.model.CommandPluginStatus.CANCELLED
  }
  case object Failed extends zio.aws.ssm.model.CommandPluginStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.CommandPluginStatus =
      software.amazon.awssdk.services.ssm.model.CommandPluginStatus.FAILED
  }
}
