package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  ApplyOnlyAtCronInterval,
  TargetMapValue,
  ParameterName,
  ParameterValue,
  TargetMapKey,
  DocumentARN,
  ScheduleExpression,
  InstanceId,
  AssociationName,
  DocumentVersion,
  ScheduleOffset,
  CalendarNameOrARN,
  AutomationTargetParameterName,
  MaxConcurrency,
  MaxErrors
}
import scala.jdk.CollectionConverters.*
final case class CreateAssociationRequest(
    name: DocumentARN,
    documentVersion: Optional[DocumentVersion] = Optional.Absent,
    instanceId: Optional[InstanceId] = Optional.Absent,
    parameters: Optional[Map[ParameterName, Iterable[ParameterValue]]] =
      Optional.Absent,
    targets: Optional[Iterable[zio.aws.ssm.model.Target]] = Optional.Absent,
    scheduleExpression: Optional[ScheduleExpression] = Optional.Absent,
    outputLocation: Optional[
      zio.aws.ssm.model.InstanceAssociationOutputLocation
    ] = Optional.Absent,
    associationName: Optional[AssociationName] = Optional.Absent,
    automationTargetParameterName: Optional[AutomationTargetParameterName] =
      Optional.Absent,
    maxErrors: Optional[MaxErrors] = Optional.Absent,
    maxConcurrency: Optional[MaxConcurrency] = Optional.Absent,
    complianceSeverity: Optional[
      zio.aws.ssm.model.AssociationComplianceSeverity
    ] = Optional.Absent,
    syncCompliance: Optional[zio.aws.ssm.model.AssociationSyncCompliance] =
      Optional.Absent,
    applyOnlyAtCronInterval: Optional[ApplyOnlyAtCronInterval] =
      Optional.Absent,
    calendarNames: Optional[Iterable[CalendarNameOrARN]] = Optional.Absent,
    targetLocations: Optional[Iterable[zio.aws.ssm.model.TargetLocation]] =
      Optional.Absent,
    scheduleOffset: Optional[ScheduleOffset] = Optional.Absent,
    targetMaps: Optional[
      Iterable[Map[TargetMapKey, Iterable[TargetMapValue]]]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.CreateAssociationRequest = {
    import CreateAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.CreateAssociationRequest
      .builder()
      .name(DocumentARN.unwrap(name): java.lang.String)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (ParameterName.unwrap(key): java.lang.String) -> value.map {
                item =>
                  ParameterValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(
        scheduleExpression.map(value =>
          ScheduleExpression.unwrap(value): java.lang.String
        )
      )(_.scheduleExpression)
      .optionallyWith(outputLocation.map(value => value.buildAwsValue()))(
        _.outputLocation
      )
      .optionallyWith(
        associationName.map(value =>
          AssociationName.unwrap(value): java.lang.String
        )
      )(_.associationName)
      .optionallyWith(
        automationTargetParameterName.map(value =>
          AutomationTargetParameterName.unwrap(value): java.lang.String
        )
      )(_.automationTargetParameterName)
      .optionallyWith(
        maxErrors.map(value => MaxErrors.unwrap(value): java.lang.String)
      )(_.maxErrors)
      .optionallyWith(
        maxConcurrency.map(value =>
          MaxConcurrency.unwrap(value): java.lang.String
        )
      )(_.maxConcurrency)
      .optionallyWith(complianceSeverity.map(value => value.unwrap))(
        _.complianceSeverity
      )
      .optionallyWith(syncCompliance.map(value => value.unwrap))(
        _.syncCompliance
      )
      .optionallyWith(
        applyOnlyAtCronInterval.map(value =>
          ApplyOnlyAtCronInterval.unwrap(value): java.lang.Boolean
        )
      )(_.applyOnlyAtCronInterval)
      .optionallyWith(
        calendarNames.map(value =>
          value.map { item =>
            CalendarNameOrARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.calendarNames)
      .optionallyWith(
        targetLocations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetLocations)
      .optionallyWith(
        scheduleOffset.map(value => ScheduleOffset.unwrap(value): Integer)
      )(_.scheduleOffset)
      .optionallyWith(
        targetMaps.map(value =>
          value.map { item =>
            item
              .map({ case (key, value) =>
                (TargetMapKey.unwrap(key): java.lang.String) -> value.map {
                  item =>
                    TargetMapValue.unwrap(item): java.lang.String
                }.asJavaCollection
              })
              .asJava
          }.asJavaCollection
        )
      )(_.targetMaps)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.CreateAssociationRequest.ReadOnly =
    zio.aws.ssm.model.CreateAssociationRequest.wrap(buildAwsValue())
}
object CreateAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.CreateAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.CreateAssociationRequest =
      zio.aws.ssm.model.CreateAssociationRequest(
        name,
        documentVersion.map(value => value),
        instanceId.map(value => value),
        parameters.map(value => value),
        targets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scheduleExpression.map(value => value),
        outputLocation.map(value => value.asEditable),
        associationName.map(value => value),
        automationTargetParameterName.map(value => value),
        maxErrors.map(value => value),
        maxConcurrency.map(value => value),
        complianceSeverity.map(value => value),
        syncCompliance.map(value => value),
        applyOnlyAtCronInterval.map(value => value),
        calendarNames.map(value => value),
        targetLocations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scheduleOffset.map(value => value),
        targetMaps.map(value => value)
      )
    def name: DocumentARN
    def documentVersion: Optional[DocumentVersion]
    def instanceId: Optional[InstanceId]
    def parameters: Optional[Map[ParameterName, List[ParameterValue]]]
    def targets: Optional[List[zio.aws.ssm.model.Target.ReadOnly]]
    def scheduleExpression: Optional[ScheduleExpression]
    def outputLocation
        : Optional[zio.aws.ssm.model.InstanceAssociationOutputLocation.ReadOnly]
    def associationName: Optional[AssociationName]
    def automationTargetParameterName: Optional[AutomationTargetParameterName]
    def maxErrors: Optional[MaxErrors]
    def maxConcurrency: Optional[MaxConcurrency]
    def complianceSeverity
        : Optional[zio.aws.ssm.model.AssociationComplianceSeverity]
    def syncCompliance: Optional[zio.aws.ssm.model.AssociationSyncCompliance]
    def applyOnlyAtCronInterval: Optional[ApplyOnlyAtCronInterval]
    def calendarNames: Optional[List[CalendarNameOrARN]]
    def targetLocations
        : Optional[List[zio.aws.ssm.model.TargetLocation.ReadOnly]]
    def scheduleOffset: Optional[ScheduleOffset]
    def targetMaps: Optional[List[Map[TargetMapKey, List[TargetMapValue]]]]
    def getName: ZIO[Any, Nothing, DocumentARN] = ZIO.succeed(name)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getParameters
        : ZIO[Any, AwsError, Map[ParameterName, List[ParameterValue]]] =
      AwsError.unwrapOptionField("parameters", parameters)
    def getTargets
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Target.ReadOnly]] =
      AwsError.unwrapOptionField("targets", targets)
    def getScheduleExpression: ZIO[Any, AwsError, ScheduleExpression] =
      AwsError.unwrapOptionField("scheduleExpression", scheduleExpression)
    def getOutputLocation: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.InstanceAssociationOutputLocation.ReadOnly
    ] = AwsError.unwrapOptionField("outputLocation", outputLocation)
    def getAssociationName: ZIO[Any, AwsError, AssociationName] =
      AwsError.unwrapOptionField("associationName", associationName)
    def getAutomationTargetParameterName
        : ZIO[Any, AwsError, AutomationTargetParameterName] =
      AwsError.unwrapOptionField(
        "automationTargetParameterName",
        automationTargetParameterName
      )
    def getMaxErrors: ZIO[Any, AwsError, MaxErrors] =
      AwsError.unwrapOptionField("maxErrors", maxErrors)
    def getMaxConcurrency: ZIO[Any, AwsError, MaxConcurrency] =
      AwsError.unwrapOptionField("maxConcurrency", maxConcurrency)
    def getComplianceSeverity
        : ZIO[Any, AwsError, zio.aws.ssm.model.AssociationComplianceSeverity] =
      AwsError.unwrapOptionField("complianceSeverity", complianceSeverity)
    def getSyncCompliance
        : ZIO[Any, AwsError, zio.aws.ssm.model.AssociationSyncCompliance] =
      AwsError.unwrapOptionField("syncCompliance", syncCompliance)
    def getApplyOnlyAtCronInterval
        : ZIO[Any, AwsError, ApplyOnlyAtCronInterval] = AwsError
      .unwrapOptionField("applyOnlyAtCronInterval", applyOnlyAtCronInterval)
    def getCalendarNames: ZIO[Any, AwsError, List[CalendarNameOrARN]] =
      AwsError.unwrapOptionField("calendarNames", calendarNames)
    def getTargetLocations
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.TargetLocation.ReadOnly]] =
      AwsError.unwrapOptionField("targetLocations", targetLocations)
    def getScheduleOffset: ZIO[Any, AwsError, ScheduleOffset] =
      AwsError.unwrapOptionField("scheduleOffset", scheduleOffset)
    def getTargetMaps
        : ZIO[Any, AwsError, List[Map[TargetMapKey, List[TargetMapValue]]]] =
      AwsError.unwrapOptionField("targetMaps", targetMaps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.CreateAssociationRequest
  ) extends zio.aws.ssm.model.CreateAssociationRequest.ReadOnly {
    override val name: DocumentARN =
      zio.aws.ssm.model.primitives.DocumentARN(impl.name())
    override val documentVersion: Optional[DocumentVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentVersion())
        .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val instanceId: Optional[InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => zio.aws.ssm.model.primitives.InstanceId(value))
    override val parameters
        : Optional[Map[ParameterName, List[ParameterValue]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.ssm.model.primitives
                .ParameterName(key) -> value.asScala.map { item =>
                zio.aws.ssm.model.primitives.ParameterValue(item)
              }.toList
            })
            .toMap
        )
    override val targets: Optional[List[zio.aws.ssm.model.Target.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Target.wrap(item)
          }.toList
        )
    override val scheduleExpression: Optional[ScheduleExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduleExpression())
        .map(value => zio.aws.ssm.model.primitives.ScheduleExpression(value))
    override val outputLocation: Optional[
      zio.aws.ssm.model.InstanceAssociationOutputLocation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.outputLocation())
      .map(value =>
        zio.aws.ssm.model.InstanceAssociationOutputLocation.wrap(value)
      )
    override val associationName: Optional[AssociationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationName())
        .map(value => zio.aws.ssm.model.primitives.AssociationName(value))
    override val automationTargetParameterName
        : Optional[AutomationTargetParameterName] = zio.aws.core.internal
      .optionalFromNullable(impl.automationTargetParameterName())
      .map(value =>
        zio.aws.ssm.model.primitives.AutomationTargetParameterName(value)
      )
    override val maxErrors: Optional[MaxErrors] = zio.aws.core.internal
      .optionalFromNullable(impl.maxErrors())
      .map(value => zio.aws.ssm.model.primitives.MaxErrors(value))
    override val maxConcurrency: Optional[MaxConcurrency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxConcurrency())
        .map(value => zio.aws.ssm.model.primitives.MaxConcurrency(value))
    override val complianceSeverity
        : Optional[zio.aws.ssm.model.AssociationComplianceSeverity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceSeverity())
        .map(value =>
          zio.aws.ssm.model.AssociationComplianceSeverity.wrap(value)
        )
    override val syncCompliance
        : Optional[zio.aws.ssm.model.AssociationSyncCompliance] =
      zio.aws.core.internal
        .optionalFromNullable(impl.syncCompliance())
        .map(value => zio.aws.ssm.model.AssociationSyncCompliance.wrap(value))
    override val applyOnlyAtCronInterval: Optional[ApplyOnlyAtCronInterval] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applyOnlyAtCronInterval())
        .map(value =>
          zio.aws.ssm.model.primitives.ApplyOnlyAtCronInterval(value)
        )
    override val calendarNames: Optional[List[CalendarNameOrARN]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.calendarNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.primitives.CalendarNameOrARN(item)
          }.toList
        )
    override val targetLocations
        : Optional[List[zio.aws.ssm.model.TargetLocation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetLocations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.TargetLocation.wrap(item)
          }.toList
        )
    override val scheduleOffset: Optional[ScheduleOffset] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduleOffset())
        .map(value => zio.aws.ssm.model.primitives.ScheduleOffset(value))
    override val targetMaps
        : Optional[List[Map[TargetMapKey, List[TargetMapValue]]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetMaps())
        .map(value =>
          value.asScala.map { item =>
            item.asScala
              .map({ case (key, value) =>
                zio.aws.ssm.model.primitives
                  .TargetMapKey(key) -> value.asScala.map { item =>
                  zio.aws.ssm.model.primitives.TargetMapValue(item)
                }.toList
              })
              .toMap
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.CreateAssociationRequest
  ): zio.aws.ssm.model.CreateAssociationRequest.ReadOnly = new Wrapper(impl)
}
