package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.PSParameterName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteParameterRequest(name: PSParameterName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DeleteParameterRequest = {
    import DeleteParameterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DeleteParameterRequest
      .builder()
      .name(PSParameterName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DeleteParameterRequest.ReadOnly =
    zio.aws.ssm.model.DeleteParameterRequest.wrap(buildAwsValue())
}
object DeleteParameterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DeleteParameterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DeleteParameterRequest =
      zio.aws.ssm.model.DeleteParameterRequest(name)
    def name: PSParameterName
    def getName: ZIO[Any, Nothing, PSParameterName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DeleteParameterRequest
  ) extends zio.aws.ssm.model.DeleteParameterRequest.ReadOnly {
    override val name: PSParameterName =
      zio.aws.ssm.model.primitives.PSParameterName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DeleteParameterRequest
  ): zio.aws.ssm.model.DeleteParameterRequest.ReadOnly = new Wrapper(impl)
}
