package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait DocumentHashType {
  def unwrap: software.amazon.awssdk.services.ssm.model.DocumentHashType
}
object DocumentHashType {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.DocumentHashType
  ): zio.aws.ssm.model.DocumentHashType = value match {
    case software.amazon.awssdk.services.ssm.model.DocumentHashType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.DocumentHashType.SHA256 =>
      val r = Sha256
      r
    case software.amazon.awssdk.services.ssm.model.DocumentHashType.SHA1 =>
      val r = Sha1
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.DocumentHashType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentHashType =
      software.amazon.awssdk.services.ssm.model.DocumentHashType.UNKNOWN_TO_SDK_VERSION
  }
  case object Sha256 extends zio.aws.ssm.model.DocumentHashType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentHashType =
      software.amazon.awssdk.services.ssm.model.DocumentHashType.SHA256
  }
  case object Sha1 extends zio.aws.ssm.model.DocumentHashType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentHashType =
      software.amazon.awssdk.services.ssm.model.DocumentHashType.SHA1
  }
}
