package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait Fault {
  def unwrap: software.amazon.awssdk.services.ssm.model.Fault
}
object Fault {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.Fault
  ): zio.aws.ssm.model.Fault = value match {
    case software.amazon.awssdk.services.ssm.model.Fault.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.Fault.CLIENT =>
      val r = Client
      r
    case software.amazon.awssdk.services.ssm.model.Fault.SERVER =>
      val r = Server
      r
    case software.amazon.awssdk.services.ssm.model.Fault.UNKNOWN =>
      val r = Unknown
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.Fault {
    override def unwrap: software.amazon.awssdk.services.ssm.model.Fault =
      software.amazon.awssdk.services.ssm.model.Fault.UNKNOWN_TO_SDK_VERSION
  }
  case object Client extends zio.aws.ssm.model.Fault {
    override def unwrap: software.amazon.awssdk.services.ssm.model.Fault =
      software.amazon.awssdk.services.ssm.model.Fault.CLIENT
  }
  case object Server extends zio.aws.ssm.model.Fault {
    override def unwrap: software.amazon.awssdk.services.ssm.model.Fault =
      software.amazon.awssdk.services.ssm.model.Fault.SERVER
  }
  case object Unknown extends zio.aws.ssm.model.Fault {
    override def unwrap: software.amazon.awssdk.services.ssm.model.Fault =
      software.amazon.awssdk.services.ssm.model.Fault.UNKNOWN
  }
}
