package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{CommandPluginName, InstanceId, CommandId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetCommandInvocationRequest(
    commandId: CommandId,
    instanceId: InstanceId,
    pluginName: Optional[CommandPluginName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetCommandInvocationRequest = {
    import GetCommandInvocationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetCommandInvocationRequest
      .builder()
      .commandId(CommandId.unwrap(commandId): java.lang.String)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(
        pluginName.map(value =>
          CommandPluginName.unwrap(value): java.lang.String
        )
      )(_.pluginName)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetCommandInvocationRequest.ReadOnly =
    zio.aws.ssm.model.GetCommandInvocationRequest.wrap(buildAwsValue())
}
object GetCommandInvocationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetCommandInvocationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetCommandInvocationRequest =
      zio.aws.ssm.model.GetCommandInvocationRequest(
        commandId,
        instanceId,
        pluginName.map(value => value)
      )
    def commandId: CommandId
    def instanceId: InstanceId
    def pluginName: Optional[CommandPluginName]
    def getCommandId: ZIO[Any, Nothing, CommandId] = ZIO.succeed(commandId)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getPluginName: ZIO[Any, AwsError, CommandPluginName] =
      AwsError.unwrapOptionField("pluginName", pluginName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetCommandInvocationRequest
  ) extends zio.aws.ssm.model.GetCommandInvocationRequest.ReadOnly {
    override val commandId: CommandId =
      zio.aws.ssm.model.primitives.CommandId(impl.commandId())
    override val instanceId: InstanceId =
      zio.aws.ssm.model.primitives.InstanceId(impl.instanceId())
    override val pluginName: Optional[CommandPluginName] = zio.aws.core.internal
      .optionalFromNullable(impl.pluginName())
      .map(value => zio.aws.ssm.model.primitives.CommandPluginName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetCommandInvocationRequest
  ): zio.aws.ssm.model.GetCommandInvocationRequest.ReadOnly = new Wrapper(impl)
}
